/*
 * Decompiled with CFR 0.152.
 */
package jade.content.lang.sl;

import jade.content.abs.AbsPredicate;
import jade.content.lang.sl.SL0Ontology;
import jade.content.lang.sl.SL1Vocabulary;
import jade.content.onto.BasicOntology;
import jade.content.onto.Introspector;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.schema.PredicateSchema;
import jade.core.CaseInsensitiveString;

class SL1Ontology
extends SL0Ontology
implements SL1Vocabulary {
    public static final String ONTOLOGY_NAME = "SL1-ONTOLOGY";
    private static Ontology theInstance = new SL1Ontology("SL1-ONTOLOGY", BasicOntology.getInstance(), null);

    public static Ontology getInstance() {
        return theInstance;
    }

    protected SL1Ontology(String string, Ontology ontology, Introspector introspector) {
        super(string, ontology, introspector);
        try {
            this.add(new PredicateSchema("and"), AbsPredicate.getJavaClass());
            this.add(new PredicateSchema("or"), AbsPredicate.getJavaClass());
            this.add(new PredicateSchema("not"), AbsPredicate.getJavaClass());
            PredicateSchema predicateSchema = (PredicateSchema)this.getSchema("and");
            predicateSchema.add("left", (PredicateSchema)PredicateSchema.getBaseSchema());
            predicateSchema.add("right", (PredicateSchema)PredicateSchema.getBaseSchema());
            predicateSchema = (PredicateSchema)this.getSchema("or");
            predicateSchema.add("left", (PredicateSchema)PredicateSchema.getBaseSchema());
            predicateSchema.add("right", (PredicateSchema)PredicateSchema.getBaseSchema());
            predicateSchema = (PredicateSchema)this.getSchema("not");
            predicateSchema.add("what", (PredicateSchema)PredicateSchema.getBaseSchema());
        }
        catch (OntologyException ontologyException) {
            ontologyException.printStackTrace();
        }
    }

    boolean isUnaryLogicalOp(String string) {
        return CaseInsensitiveString.equalsIgnoreCase("not", string);
    }

    boolean isBinaryLogicalOp(String string) {
        return CaseInsensitiveString.equalsIgnoreCase("and", string) || CaseInsensitiveString.equalsIgnoreCase("or", string);
    }
}

