/*
 * Decompiled with CFR 0.152.
 */
package jade.content.onto;

import jade.content.AgentAction;
import jade.content.ContentElementList;
import jade.content.abs.AbsAgentAction;
import jade.content.abs.AbsAggregate;
import jade.content.abs.AbsConcept;
import jade.content.abs.AbsContentElementList;
import jade.content.abs.AbsHelper;
import jade.content.abs.AbsObject;
import jade.content.abs.AbsPredicate;
import jade.content.abs.AbsPrimitive;
import jade.content.abs.AbsTerm;
import jade.content.lang.sl.SL0Vocabulary;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.UngroundedException;
import jade.content.onto.UnknownSchemaException;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Done;
import jade.content.onto.basic.Equals;
import jade.content.onto.basic.FalseProposition;
import jade.content.onto.basic.Result;
import jade.content.onto.basic.TrueProposition;
import jade.content.schema.AgentActionSchema;
import jade.content.schema.AggregateSchema;
import jade.content.schema.ConceptSchema;
import jade.content.schema.ContentElementListSchema;
import jade.content.schema.ObjectSchema;
import jade.content.schema.PredicateSchema;
import jade.content.schema.PrimitiveSchema;
import jade.content.schema.TermSchema;
import jade.core.AID;
import jade.core.CaseInsensitiveString;
import jade.lang.acl.ACLMessage;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import java.util.Date;

public class BasicOntology
extends Ontology
implements SL0Vocabulary {
    private static final BasicOntology theInstance = new BasicOntology();
    public static final String STRING = "BO_String";
    public static final String FLOAT = "BO_Float";
    public static final String INTEGER = "BO_Integer";
    public static final String BOOLEAN = "BO_Boolean";
    public static final String DATE = "BO_Date";
    public static final String BYTE_SEQUENCE = "BO_Byte-sequence";
    public static final String CONTENT_ELEMENT_LIST = "ContentElementList";

    private BasicOntology() {
        super("BASIC_ONTOLOGY", (Ontology)null, null);
    }

    private void initialize() {
        try {
            this.add(new PrimitiveSchema(STRING));
            this.add(new PrimitiveSchema(FLOAT));
            this.add(new PrimitiveSchema(INTEGER));
            this.add(new PrimitiveSchema(BOOLEAN));
            this.add(new PrimitiveSchema(DATE));
            this.add(new PrimitiveSchema(BYTE_SEQUENCE));
            this.add(new AggregateSchema("sequence"));
            this.add(new AggregateSchema("set"));
            this.add(ContentElementListSchema.getBaseSchema());
            ConceptSchema conceptSchema = new ConceptSchema("agent-identifier");
            conceptSchema.add("name", (TermSchema)this.getSchema(STRING));
            conceptSchema.add("addresses", (TermSchema)this.getSchema(STRING), 0, -1);
            conceptSchema.add("resolvers", conceptSchema, 0, -1);
            this.add(conceptSchema);
            AgentActionSchema agentActionSchema = new AgentActionSchema("fipa-acl-message");
            agentActionSchema.add("sender", (ConceptSchema)this.getSchema("agent-identifier"), 1);
            agentActionSchema.add("receivers", (ConceptSchema)this.getSchema("agent-identifier"), 0, -1);
            agentActionSchema.add("reply-to", (ConceptSchema)this.getSchema("agent-identifier"), 0, -1);
            agentActionSchema.add("language", (PrimitiveSchema)this.getSchema(STRING), 1);
            agentActionSchema.add("ontology", (PrimitiveSchema)this.getSchema(STRING), 1);
            agentActionSchema.add("protocol", (PrimitiveSchema)this.getSchema(STRING), 1);
            agentActionSchema.add("in-reply-to", (PrimitiveSchema)this.getSchema(STRING), 1);
            agentActionSchema.add("reply-with", (PrimitiveSchema)this.getSchema(STRING), 1);
            agentActionSchema.add("conversation-id", (PrimitiveSchema)this.getSchema(STRING), 1);
            agentActionSchema.add("reply-by", (PrimitiveSchema)this.getSchema(DATE), 1);
            agentActionSchema.add("content", (PrimitiveSchema)this.getSchema(STRING), 1);
            agentActionSchema.add("bs-content", (PrimitiveSchema)this.getSchema(BYTE_SEQUENCE), 1);
            agentActionSchema.add("encoding", (PrimitiveSchema)this.getSchema(STRING), 1);
            this.add(agentActionSchema);
            PredicateSchema predicateSchema = new PredicateSchema("true");
            this.add(predicateSchema);
            PredicateSchema predicateSchema2 = new PredicateSchema("false");
            this.add(predicateSchema2);
            AgentActionSchema agentActionSchema2 = new AgentActionSchema("action");
            agentActionSchema2.add("actor", (TermSchema)this.getSchema("agent-identifier"));
            agentActionSchema2.add("action", (TermSchema)ConceptSchema.getBaseSchema());
            agentActionSchema2.setEncodingByOrder(true);
            this.add(agentActionSchema2);
            PredicateSchema predicateSchema3 = new PredicateSchema("done");
            predicateSchema3.add("action", (AgentActionSchema)AgentActionSchema.getBaseSchema());
            predicateSchema3.add("condition", (PredicateSchema)PredicateSchema.getBaseSchema(), 1);
            this.add(predicateSchema3);
            PredicateSchema predicateSchema4 = new PredicateSchema("result");
            predicateSchema4.add("action", (AgentActionSchema)AgentActionSchema.getBaseSchema());
            predicateSchema4.add("value", (TermSchema)TermSchema.getBaseSchema());
            this.add(predicateSchema4);
            PredicateSchema predicateSchema5 = new PredicateSchema("=");
            predicateSchema5.add("left", TermSchema.getBaseSchema());
            predicateSchema5.add("right", TermSchema.getBaseSchema());
            this.add(predicateSchema5);
        }
        catch (OntologyException ontologyException) {
            ontologyException.printStackTrace();
        }
    }

    public static Ontology getInstance() {
        return theInstance;
    }

    protected Object toObject(AbsObject absObject, String string, Ontology ontology) throws UngroundedException, OntologyException {
        try {
            if (absObject == null) {
                return null;
            }
            if (absObject instanceof AbsPrimitive) {
                return ((AbsPrimitive)absObject).getObject();
            }
            if (absObject instanceof AbsAggregate) {
                return AbsHelper.internaliseList((AbsAggregate)absObject, ontology);
            }
            if (absObject instanceof AbsContentElementList) {
                return AbsHelper.internaliseContentElementList((AbsContentElementList)absObject, ontology);
            }
            if (CaseInsensitiveString.equalsIgnoreCase(absObject.getTypeName(), "agent-identifier")) {
                return AbsHelper.internaliseAID((AbsConcept)absObject);
            }
            if (CaseInsensitiveString.equalsIgnoreCase(absObject.getTypeName(), "true")) {
                TrueProposition trueProposition = new TrueProposition();
                return trueProposition;
            }
            if (CaseInsensitiveString.equalsIgnoreCase(absObject.getTypeName(), "false")) {
                FalseProposition falseProposition = new FalseProposition();
                return falseProposition;
            }
            if (CaseInsensitiveString.equalsIgnoreCase(absObject.getTypeName(), "done")) {
                Done done = new Done();
                done.setAction((AgentAction)ontology.toObject(absObject.getAbsObject("action")));
                return done;
            }
            if (CaseInsensitiveString.equalsIgnoreCase(absObject.getTypeName(), "result")) {
                Result result = new Result();
                result.setAction((AgentAction)ontology.toObject(absObject.getAbsObject("action")));
                result.setValue(ontology.toObject(absObject.getAbsObject("value")));
                return result;
            }
            if (CaseInsensitiveString.equalsIgnoreCase(absObject.getTypeName(), "=")) {
                Equals equals = new Equals();
                equals.setLeft(ontology.toObject(absObject.getAbsObject("left")));
                equals.setRight(ontology.toObject(absObject.getAbsObject("right")));
                return equals;
            }
            if (CaseInsensitiveString.equalsIgnoreCase(absObject.getTypeName(), "action")) {
                Action action = new Action();
                action.internalise(absObject, ontology);
                return action;
            }
            if (ACLMessage.getInteger(absObject.getTypeName()) != -1) {
                return AbsHelper.internaliseACLMessage((AbsAgentAction)absObject, ontology);
            }
            throw new UnknownSchemaException();
        }
        catch (OntologyException ontologyException) {
            throw ontologyException;
        }
        catch (Throwable throwable) {
            throw new OntologyException("Unexpected error internalising " + absObject + ".", throwable);
        }
    }

    protected AbsObject fromObject(Object object, Ontology ontology) throws OntologyException {
        try {
            if (object == null) {
                return null;
            }
            if (object instanceof String) {
                return AbsPrimitive.wrap((String)object);
            }
            if (object instanceof Boolean) {
                return AbsPrimitive.wrap((Boolean)object);
            }
            if (object instanceof Integer) {
                return AbsPrimitive.wrap((Integer)object);
            }
            if (object instanceof Long) {
                return AbsPrimitive.wrap((Long)object);
            }
            if (object instanceof Float) {
                return AbsPrimitive.wrap(((Float)object).floatValue());
            }
            if (object instanceof Double) {
                return AbsPrimitive.wrap((Double)object);
            }
            if (object instanceof Date) {
                return AbsPrimitive.wrap((Date)object);
            }
            if (object instanceof byte[]) {
                return AbsPrimitive.wrap((byte[])object);
            }
            if (object instanceof List) {
                return AbsHelper.externaliseList((List)object, ontology, "sequence");
            }
            if (object instanceof Iterator) {
                return AbsHelper.externaliseIterator((Iterator)object, ontology, "sequence");
            }
            if (object instanceof AID) {
                return AbsHelper.externaliseAID((AID)object);
            }
            if (object instanceof ContentElementList) {
                return AbsHelper.externaliseContentElementList((ContentElementList)object, ontology);
            }
            if (object instanceof TrueProposition) {
                AbsPredicate absPredicate = new AbsPredicate("true");
                return absPredicate;
            }
            if (object instanceof FalseProposition) {
                AbsPredicate absPredicate = new AbsPredicate("false");
                return absPredicate;
            }
            if (object instanceof Done) {
                AbsPredicate absPredicate = new AbsPredicate("done");
                absPredicate.set("action", (AbsAgentAction)ontology.fromObject(((Done)object).getAction()));
                return absPredicate;
            }
            if (object instanceof Result) {
                AbsPredicate absPredicate = new AbsPredicate("result");
                absPredicate.set("action", (AbsAgentAction)ontology.fromObject(((Result)object).getAction()));
                absPredicate.set("value", (AbsTerm)ontology.fromObject(((Result)object).getValue()));
                return absPredicate;
            }
            if (object instanceof Equals) {
                AbsPredicate absPredicate = new AbsPredicate("=");
                absPredicate.set("left", (AbsTerm)ontology.fromObject(((Equals)object).getLeft()));
                absPredicate.set("right", (AbsTerm)ontology.fromObject(((Equals)object).getRight()));
                return absPredicate;
            }
            if (object instanceof Action) {
                AbsAgentAction absAgentAction = new AbsAgentAction("action");
                ((Action)object).externalise(absAgentAction, ontology);
                return absAgentAction;
            }
            if (object instanceof ACLMessage) {
                return AbsHelper.externaliseACLMessage((ACLMessage)object, ontology);
            }
            throw new UnknownSchemaException();
        }
        catch (OntologyException ontologyException) {
            throw ontologyException;
        }
        catch (Throwable throwable) {
            throw new OntologyException("Unexpected error externalising " + object + ".", throwable);
        }
    }

    public ObjectSchema getSchema(String string) throws OntologyException {
        int n;
        ObjectSchema objectSchema = super.getSchema(string);
        if (objectSchema == null && (n = ACLMessage.getInteger(string)) != -1) {
            objectSchema = this.createMsgSchema(string);
        }
        return objectSchema;
    }

    private ObjectSchema createMsgSchema(String string) throws OntologyException {
        AgentActionSchema agentActionSchema = new AgentActionSchema(string);
        agentActionSchema.addSuperSchema((AgentActionSchema)this.getSchema("fipa-acl-message"));
        return agentActionSchema;
    }

    static {
        theInstance.initialize();
    }
}

