/*
 * Decompiled with CFR 0.152.
 */
package jade.content.onto;

import jade.content.abs.AbsObject;
import jade.content.onto.Introspectable;
import jade.content.onto.Introspector;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.UngroundedException;
import jade.content.schema.ObjectSchema;

public class MicroIntrospector
implements Introspector {
    public AbsObject externalise(Object object, ObjectSchema objectSchema, Class clazz, Ontology ontology) throws OntologyException {
        try {
            AbsObject absObject = objectSchema.newInstance();
            Introspectable introspectable = (Introspectable)object;
            introspectable.externalise(absObject, ontology);
            return absObject;
        }
        catch (OntologyException ontologyException) {
            throw ontologyException;
        }
        catch (ClassCastException classCastException) {
            throw new OntologyException("Object " + object + " is not Introspectable");
        }
        catch (Throwable throwable) {
            throw new OntologyException("Schema and Java class do not match", throwable);
        }
    }

    public Object internalise(AbsObject absObject, ObjectSchema objectSchema, Class clazz, Ontology ontology) throws UngroundedException, OntologyException {
        try {
            Object t = clazz.newInstance();
            Introspectable introspectable = (Introspectable)t;
            introspectable.internalise(absObject, ontology);
            return introspectable;
        }
        catch (OntologyException ontologyException) {
            throw ontologyException;
        }
        catch (ClassCastException classCastException) {
            throw new OntologyException("Class for type " + absObject.getTypeName() + " is not Introspectable");
        }
        catch (Throwable throwable) {
            throw new OntologyException("Schema and Java class do not match", throwable);
        }
    }

    public void checkClass(ObjectSchema objectSchema, Class clazz, Ontology ontology) throws OntologyException {
    }
}

