/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.CaseInsensitiveString;

public class AgentState {
    private static final AgentState[] STATES = new AgentState[]{new AgentState("Illegal MIN state", 0), new AgentState("Initiated", 1), new AgentState("Active", 2), new AgentState("Idle", 3), new AgentState("Suspended", 4), new AgentState("Waiting", 5), new AgentState("Deleted", 6), new AgentState("Transit", 7), new AgentState("Copy", 8), new AgentState("Gone", 9), new AgentState("Saving", 10), new AgentState("Loading", 11), new AgentState("Frozen", 12), new AgentState("Illegal MAX state", 13)};
    private Long persistentID;
    private String name;
    private int value;

    public static AgentState getInstance(int n) {
        int n2 = 0;
        while (n2 < STATES.length) {
            AgentState agentState = STATES[n2];
            if (agentState.getValue() == n) {
                return agentState;
            }
            ++n2;
        }
        return null;
    }

    public static AgentState[] getAllInstances() {
        return STATES;
    }

    public AgentState() {
    }

    private AgentState(String string, int n) {
        this.name = string;
        this.value = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setValue(int n) {
        this.value = n;
    }

    public int getValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object instanceof String) {
            return CaseInsensitiveString.equalsIgnoreCase(this.name, (String)object);
        }
        try {
            AgentState agentState = (AgentState)object;
            return CaseInsensitiveString.equalsIgnoreCase(this.name, agentState.name);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public String toString() {
        return this.name;
    }

    public int compareTo(Object object) {
        AgentState agentState = (AgentState)object;
        return this.name.toLowerCase().toUpperCase().compareTo(agentState.name.toLowerCase().toUpperCase());
    }

    public int hashCode() {
        return this.name.toLowerCase().hashCode();
    }

    private Long getPersistentID() {
        return this.persistentID;
    }

    private void setPersistentID(Long l) {
        this.persistentID = l;
    }
}

