/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.ResourceManager;

class FullResourceManager
implements ResourceManager {
    private static final String USER_AGENTS_GROUP_NAME = "JADE User Agents";
    private static final String SYSTEM_AGENTS_GROUP_NAME = "JADE System Agents";
    private static final String CRITICAL_THREADS_GROUP_NAME = "JADE Time-critical Threads";
    private ThreadGroup parent = new ThreadGroup("FIXME: Dummy name");
    private ThreadGroup agentThreads = new ThreadGroup(this.parent, "JADE User Agents");
    private ThreadGroup systemAgentThreads;
    private ThreadGroup criticalThreads;

    public FullResourceManager() {
        this.agentThreads.setMaxPriority(5);
        this.systemAgentThreads = new ThreadGroup(this.parent, SYSTEM_AGENTS_GROUP_NAME);
        this.systemAgentThreads.setMaxPriority(5);
        this.criticalThreads = new ThreadGroup(this.parent, CRITICAL_THREADS_GROUP_NAME);
        this.criticalThreads.setMaxPriority(10);
    }

    public Thread getThread(int n, String string, Runnable runnable) {
        Thread thread = null;
        switch (n) {
            case 0: {
                thread = new Thread(this.agentThreads, runnable);
                thread.setPriority(this.agentThreads.getMaxPriority());
                break;
            }
            case 1: {
                thread = new Thread(this.systemAgentThreads, runnable);
                thread.setPriority(this.systemAgentThreads.getMaxPriority());
                break;
            }
            case 2: {
                thread = new Thread(this.criticalThreads, runnable);
                thread.setPriority(this.criticalThreads.getMaxPriority());
            }
        }
        if (thread != null) {
            thread.setName(string);
        }
        return thread;
    }

    public void releaseResources() {
        if (this.parent != null) {
            this.parent.interrupt();
        }
        this.agentThreads = null;
        this.systemAgentThreads = null;
        this.criticalThreads = null;
        this.parent = null;
    }
}

