/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.BaseService;
import jade.core.CommandProcessor;
import jade.core.ContainerID;
import jade.core.Filter;
import jade.core.IMTPException;
import jade.core.IMTPManager;
import jade.core.Node;
import jade.core.NodeDescriptor;
import jade.core.PlatformManager;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.Service;
import jade.core.ServiceDescriptor;
import jade.core.ServiceException;
import jade.core.ServiceFinder;
import jade.core.ServiceManager;
import jade.core.Sink;
import jade.security.JADESecurityException;
import jade.util.Logger;
import jade.util.leap.HashMap;
import jade.util.leap.Map;
import java.util.Vector;

public class ServiceManagerImpl
implements ServiceManager,
ServiceFinder {
    private IMTPManager myIMTPManager;
    private CommandProcessor myCommandProcessor;
    private PlatformManager myPlatformManager;
    private boolean invalidPlatformManager;
    private String platformName;
    private Node localNode;
    private Map localServices;
    private Map backupManagers;
    private Logger myLogger;

    ServiceManagerImpl(Profile profile, PlatformManager platformManager) throws ProfileException {
        this.myCommandProcessor = profile.getCommandProcessor();
        this.myIMTPManager = profile.getIMTPManager();
        this.myPlatformManager = platformManager;
        this.invalidPlatformManager = false;
        this.localServices = new HashMap(5);
        this.backupManagers = new HashMap(1);
        this.myLogger = Logger.getMyLogger(this.getClass().getName());
    }

    public String getPlatformName() throws IMTPException {
        if (this.platformName == null) {
            try {
                this.platformName = this.myPlatformManager.getPlatformName();
            }
            catch (IMTPException iMTPException) {
                if (this.reconnect()) {
                    this.platformName = this.myPlatformManager.getPlatformName();
                }
                throw iMTPException;
            }
        }
        return this.platformName;
    }

    public synchronized void addAddress(String string) throws IMTPException {
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "Adding PlatformManager address " + string);
        }
        if (this.invalidPlatformManager || !string.equals(this.myPlatformManager.getLocalAddress())) {
            this.backupManagers.put(string, this.myIMTPManager.getPlatformManagerProxy(string));
            if (this.invalidPlatformManager) {
                this.reconnect();
            }
        }
    }

    public synchronized void removeAddress(String string) throws IMTPException {
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "Removing PlatformManager address " + string);
        }
        this.backupManagers.remove(string);
        if (string.equals(this.myPlatformManager.getLocalAddress())) {
            this.reconnect();
        }
    }

    public String getLocalAddress() throws IMTPException {
        return this.myPlatformManager.getLocalAddress();
    }

    public void addNode(NodeDescriptor nodeDescriptor, ServiceDescriptor[] serviceDescriptorArray) throws IMTPException, ServiceException, JADESecurityException {
        this.localNode = nodeDescriptor.getNode();
        try {
            Object object;
            Vector<ServiceDescriptor> vector = new Vector<ServiceDescriptor>(serviceDescriptorArray != null ? serviceDescriptorArray.length : 0);
            if (serviceDescriptorArray != null) {
                int n = 0;
                while (n < serviceDescriptorArray.length) {
                    object = serviceDescriptorArray[n].getService();
                    this.installServiceLocally((Service)object);
                    vector.addElement(serviceDescriptorArray[n]);
                    ++n;
                }
            }
            String string = null;
            try {
                string = this.myPlatformManager.addNode(nodeDescriptor, vector, false);
            }
            catch (IMTPException iMTPException) {
                if (this.reconnect()) {
                    string = this.myPlatformManager.addNode(nodeDescriptor, vector, false);
                }
                throw iMTPException;
            }
            this.localNode.setName(string);
            object = nodeDescriptor.getContainer();
            if (object != null) {
                ((ContainerID)object).setName(string);
            }
        }
        catch (IMTPException iMTPException) {
            throw iMTPException;
        }
        catch (ServiceException serviceException) {
            throw serviceException;
        }
        catch (JADESecurityException jADESecurityException) {
            throw jADESecurityException;
        }
        catch (Throwable throwable) {
            throw new ServiceException("Unexpected error activating node", throwable);
        }
    }

    public void removeNode(NodeDescriptor nodeDescriptor) throws IMTPException, ServiceException {
        Object[] objectArray = this.localServices.keySet().toArray();
        int n = 0;
        while (n < objectArray.length) {
            try {
                String string = (String)objectArray[n];
                this.uninstallServiceLocally(string);
            }
            catch (IMTPException iMTPException) {
                iMTPException.printStackTrace();
            }
            ++n;
        }
        if (nodeDescriptor.getNode().hasPlatformManager()) {
            this.myIMTPManager.unexportPlatformManager(this.myPlatformManager);
        }
    }

    public void activateService(ServiceDescriptor serviceDescriptor) throws IMTPException, ServiceException {
        block5: {
            Service service = serviceDescriptor.getService();
            try {
                this.installServiceLocally(service);
                try {
                    this.myPlatformManager.addSlice(serviceDescriptor, new NodeDescriptor(this.localNode), false);
                }
                catch (IMTPException iMTPException) {
                    if (this.reconnect()) {
                        this.myPlatformManager.addSlice(serviceDescriptor, new NodeDescriptor(this.localNode), false);
                        break block5;
                    }
                    throw iMTPException;
                }
            }
            catch (IMTPException iMTPException) {
                this.uninstallServiceLocally(service.getName());
                throw iMTPException;
            }
        }
    }

    public void deactivateService(ServiceDescriptor serviceDescriptor) throws IMTPException, ServiceException {
        String string = serviceDescriptor.getName();
        try {
            this.myPlatformManager.removeSlice(string, this.localNode.getName(), false);
        }
        catch (IMTPException iMTPException) {
            if (this.reconnect()) {
                this.myPlatformManager.removeSlice(string, this.localNode.getName(), false);
            }
            throw iMTPException;
        }
        this.uninstallServiceLocally(string);
    }

    public Service findService(String string) throws IMTPException, ServiceException {
        return (Service)this.localServices.get(string);
    }

    public Service.Slice findSlice(String string, String string2) throws IMTPException, ServiceException {
        Service.Slice slice = null;
        try {
            slice = this.myPlatformManager.findSlice(string, string2);
        }
        catch (IMTPException iMTPException) {
            if (this.reconnect()) {
                slice = this.myPlatformManager.findSlice(string, string2);
            }
            throw iMTPException;
        }
        return this.checkLocal(slice);
    }

    public Service.Slice[] findAllSlices(String string) throws IMTPException, ServiceException {
        Vector vector = null;
        try {
            vector = this.myPlatformManager.findAllSlices(string);
        }
        catch (IMTPException iMTPException) {
            if (this.reconnect()) {
                vector = this.myPlatformManager.findAllSlices(string);
            }
            throw iMTPException;
        }
        if (vector == null) {
            return null;
        }
        Service.Slice[] sliceArray = new Service.Slice[vector.size()];
        int n = 0;
        while (n < sliceArray.length) {
            sliceArray[n] = this.checkLocal((Service.Slice)vector.elementAt(n));
            ++n;
        }
        return sliceArray;
    }

    private void installServiceLocally(Service service) throws IMTPException, ServiceException {
        Service.Slice slice;
        Sink sink;
        Filter filter;
        Filter filter2 = service.getCommandFilter(true);
        if (filter2 != null) {
            filter2.setServiceName(service.getName());
            this.myCommandProcessor.addFilter(filter2, true);
        }
        if ((filter = service.getCommandFilter(false)) != null) {
            filter.setServiceName(service.getName());
            this.myCommandProcessor.addFilter(filter, false);
        }
        String[] stringArray = service.getOwnedCommands();
        Sink sink2 = service.getCommandSink(false);
        if (sink2 != null) {
            this.myCommandProcessor.registerSink(sink2, false, service.getName());
        }
        if ((sink = service.getCommandSink(true)) != null) {
            this.myCommandProcessor.registerSink(sink, true, service.getName());
        }
        if ((slice = service.getLocalSlice()) != null) {
            this.localNode.exportSlice(service.getName(), slice);
        }
        this.localServices.put(service.getName(), service);
        if (service instanceof BaseService) {
            BaseService baseService = (BaseService)service;
            baseService.setCommandProcessor(this.myCommandProcessor);
        }
    }

    private void uninstallServiceLocally(String string) throws IMTPException, ServiceException {
        Service service = (Service)this.localServices.get(string);
        if (service != null) {
            Sink sink;
            Sink sink2;
            Filter filter;
            service.shutdown();
            Filter filter2 = service.getCommandFilter(true);
            if (filter2 != null) {
                this.myCommandProcessor.removeFilter(filter2, true);
            }
            if ((filter = service.getCommandFilter(false)) != null) {
                this.myCommandProcessor.removeFilter(filter, false);
            }
            if ((sink2 = service.getCommandSink(false)) != null) {
                this.myCommandProcessor.deregisterSink(false, service.getName());
            }
            if ((sink = service.getCommandSink(true)) != null) {
                this.myCommandProcessor.deregisterSink(true, service.getName());
            }
        }
        this.localNode.unexportSlice(string);
        this.localServices.remove(string);
    }

    /*
     * Unable to fully structure code
     */
    private synchronized boolean reconnect() {
        try {
            this.myPlatformManager.ping();
            return true;
        }
        catch (IMTPException var1_1) {
            this.invalidPlatformManager = true;
            var2_2 = this.backupManagers.keySet().iterator();
            ** while (var2_2.hasNext())
        }
lbl-1000:
        // 1 sources

        {
            var3_3 = (String)var2_2.next();
            try {
                this.myPlatformManager = (PlatformManager)this.backupManagers.get(var3_3);
                if (this.myLogger.isLoggable(Logger.INFO)) {
                    this.myLogger.log(Logger.INFO, "Reconnecting to PlatformManager at address " + this.myPlatformManager.getLocalAddress());
                }
                this.myPlatformManager.adopt(this.localNode, null);
                if (this.myLogger.isLoggable(Logger.INFO)) {
                    this.myLogger.log(Logger.INFO, "Reconnection OK");
                }
                this.myIMTPManager.reconnected(this.myPlatformManager);
                this.backupManagers.remove(var3_3);
                this.invalidPlatformManager = false;
                return true;
            }
            catch (Exception var4_4) {
                if (!this.myLogger.isLoggable(Logger.WARNING)) continue;
                this.myLogger.log(Logger.WARNING, "Reconnection failed");
            }
            continue;
        }
lbl25:
        // 1 sources

        return false;
    }

    private Service.Slice checkLocal(Service.Slice slice) throws ServiceException {
        Node node;
        if (slice != null && (node = slice.getNode()).getName().equals(this.localNode.getName()) && !node.equals(this.localNode)) {
            ((Service.SliceProxy)slice).setNode(this.localNode);
        }
        return slice;
    }
}

