/*
 * Decompiled with CFR 0.152.
 */
package jade.core.nodeMonitoring;

import jade.core.AgentContainer;
import jade.core.NodeFailureMonitor;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.nodeMonitoring.NodeMonitoringService;
import jade.core.nodeMonitoring.UDPMonitorClient;
import jade.core.nodeMonitoring.UDPMonitorServer;
import jade.core.nodeMonitoring.UDPNodeFailureMonitor;
import jade.util.Logger;

public class UDPNodeMonitoringService
extends NodeMonitoringService {
    private static final String PREFIX = "jade_core_nodeMonitoring_UDPNodeMonitoringService_";
    public static final String NAME = "jade.core.nodeMonitoring.UDPNodeMonitoring";
    public static final String PORT = "jade_core_nodeMonitoring_UDPNodeMonitoringService_port";
    public static final String PING_DELAY = "jade_core_nodeMonitoring_UDPNodeMonitoringService_pingdelay";
    public static final String PING_DELAY_LIMIT = "jade_core_nodeMonitoring_UDPNodeMonitoringService_pingdelaylimit";
    public static final String UNREACHABLE_LIMIT = "jade_core_nodeMonitoring_UDPNodeMonitoringService_unreachablelimit";
    public static final int DEFAULT_PORT = 28000;
    public static final int DEFAULT_PING_DELAY = 1000;
    public static final int DEFAULT_PING_DELAY_LIMIT = 3000;
    public static final int DEFAULT_UNREACHABLE_LIMIT = 10000;
    private UDPMonitorServer myServer;
    private UDPMonitorClient myClient;

    public String getName() {
        return NAME;
    }

    public void init(AgentContainer agentContainer, Profile profile) throws ProfileException {
        super.init(agentContainer, profile);
        String string = profile.getParameter("host", Profile.getDefaultNetworkName());
        int n = UDPNodeMonitoringService.getPosIntValue(profile, PORT, 28000);
        int n2 = UDPNodeMonitoringService.getPosIntValue(profile, PING_DELAY, 1000);
        int n3 = UDPNodeMonitoringService.getPosIntValue(profile, PING_DELAY_LIMIT, 3000);
        int n4 = UDPNodeMonitoringService.getPosIntValue(profile, UNREACHABLE_LIMIT, 10000);
        if (agentContainer.getMain() != null) {
            try {
                this.myServer = new UDPMonitorServer(n, n3, n4);
                this.myLogger.log(Logger.INFO, "UDPMonitorServer successfully created. Port = " + n + " pingdelaylimit = " + n3 + " unreachablelimit = " + n4);
            }
            catch (Exception exception) {
                String string2 = "Error creating UDP monitoring server";
                this.myLogger.log(Logger.SEVERE, string2);
                throw new ProfileException(string2, exception);
            }
        }
        try {
            this.myClient = new UDPMonitorClient(agentContainer.getNodeDescriptor().getNode(), string, n, n2);
            this.myClient.start();
            this.myLogger.log(Logger.INFO, "UDPMonitorClient successfully started. Host = " + string + " port = " + n + " pingdelay = " + n2);
        }
        catch (Exception exception) {
            String string3 = "Error starting UDP monitoring client";
            this.myLogger.log(Logger.SEVERE, string3);
            throw new ProfileException(string3, exception);
        }
    }

    public NodeFailureMonitor getFailureMonitor() {
        if (this.myServer != null) {
            return new UDPNodeFailureMonitor(this.myServer);
        }
        return null;
    }

    public void shutdown() {
        if (this.myClient != null) {
            this.myClient.stop();
        }
    }

    private static int getPosIntValue(Profile profile, String string, int n) {
        int n2 = Integer.valueOf(profile.getParameter(string, "-1"));
        if (n2 >= 0) {
            return n2;
        }
        return n;
    }
}

