/*
 * Decompiled with CFR 0.152.
 */
package jade.core.replication;

import jade.core.AgentContainer;
import jade.core.BaseService;
import jade.core.Command;
import jade.core.Filter;
import jade.core.GenericCommand;
import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.core.Node;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.Service;
import jade.core.ServiceException;
import jade.core.ServiceManager;
import jade.core.Sink;
import jade.core.VerticalCommand;
import jade.core.replication.AddressNotificationSlice;
import jade.util.Logger;

public class AddressNotificationService
extends BaseService {
    private Logger logger = Logger.getMyLogger(this.getClass().getName());
    private AgentContainer myContainer;
    private ServiceComponent localSlice;
    private final IncomingFilter incomingFilter = new IncomingFilter();
    private ServiceManager myServiceManager;

    public void init(AgentContainer agentContainer, Profile profile) throws ProfileException {
        super.init(agentContainer, profile);
        this.myContainer = agentContainer;
        this.localSlice = new ServiceComponent(profile);
    }

    public String getName() {
        return "jade.core.replication.AddressNotification";
    }

    public Class getHorizontalInterface() {
        try {
            return Class.forName("jade.core.replication.AddressNotificationSlice");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public Service.Slice getLocalSlice() {
        return this.localSlice;
    }

    public Filter getCommandFilter(boolean bl) {
        if (!bl) {
            return this.incomingFilter;
        }
        return null;
    }

    public Sink getCommandSink(boolean bl) {
        return null;
    }

    public String[] getOwnedCommands() {
        return null;
    }

    public void boot(Profile profile) throws ServiceException {
        try {
            Node node = this.getLocalNode();
            if (!node.hasPlatformManager()) {
                Service.Slice[] sliceArray = this.getAllSlices();
                int n = 0;
                while (n < sliceArray.length) {
                    AddressNotificationSlice addressNotificationSlice = (AddressNotificationSlice)sliceArray[n];
                    if (addressNotificationSlice.getNode().hasPlatformManager()) {
                        this.addAddress(addressNotificationSlice.getServiceManagerAddress());
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            throw new ServiceException("Boot failure", exception);
        }
    }

    private void broadcastToSlices(HorizontalCommand horizontalCommand) throws IMTPException, ServiceException {
        Service.Slice[] sliceArray = this.getAllSlices();
        int n = 0;
        while (n < sliceArray.length) {
            AddressNotificationSlice addressNotificationSlice = (AddressNotificationSlice)sliceArray[n];
            if (!addressNotificationSlice.getNode().hasPlatformManager()) {
                addressNotificationSlice.serve(horizontalCommand);
            }
            ++n;
        }
    }

    private void addAddress(String string) throws IMTPException {
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "Adding PlatformManager address " + string);
        }
        this.myServiceManager.addAddress(string);
    }

    private class ServiceComponent
    implements Service.Slice {
        public ServiceComponent(Profile profile) {
            AddressNotificationService.this.myServiceManager = AddressNotificationService.this.myContainer.getServiceManager();
        }

        public Service getService() {
            return AddressNotificationService.this;
        }

        public Node getNode() throws ServiceException {
            try {
                return AddressNotificationService.this.getLocalNode();
            }
            catch (IMTPException iMTPException) {
                throw new ServiceException("Problem in contacting the IMTP Manager", iMTPException);
            }
        }

        public VerticalCommand serve(HorizontalCommand horizontalCommand) {
            Command command;
            block5: {
                command = null;
                try {
                    String string = horizontalCommand.getName();
                    Object[] objectArray = horizontalCommand.getParams();
                    if (string.equals("1")) {
                        String string2 = (String)objectArray[0];
                        this.addServiceManagerAddress(string2);
                    } else if (string.equals("3")) {
                        horizontalCommand.setReturnValue(this.getServiceManagerAddress());
                    }
                }
                catch (Throwable throwable) {
                    horizontalCommand.setReturnValue(throwable);
                    if (command == null) break block5;
                    command.setReturnValue(throwable);
                }
            }
            return command;
        }

        private void addServiceManagerAddress(String string) throws IMTPException {
            try {
                String string2 = AddressNotificationService.this.myServiceManager.getLocalAddress();
                if (!string.equals(string2)) {
                    AddressNotificationService.this.addAddress(string);
                }
            }
            catch (IMTPException iMTPException) {
                iMTPException.printStackTrace();
            }
        }

        private String getServiceManagerAddress() throws IMTPException {
            return AddressNotificationService.this.myServiceManager.getLocalAddress();
        }
    }

    private class IncomingFilter
    extends Filter {
        private IncomingFilter() {
        }

        public boolean accept(VerticalCommand verticalCommand) {
            try {
                String string = verticalCommand.getName();
                if (string.equals("New-Replica")) {
                    this.handleAddressAdded(verticalCommand);
                }
            }
            catch (IMTPException iMTPException) {
                iMTPException.printStackTrace();
            }
            catch (ServiceException serviceException) {
                serviceException.printStackTrace();
            }
            return true;
        }

        public void handleAddressAdded(VerticalCommand verticalCommand) throws IMTPException, ServiceException {
            Object[] objectArray = verticalCommand.getParams();
            String string = (String)objectArray[0];
            GenericCommand genericCommand = new GenericCommand("1", "jade.core.replication.AddressNotification", null);
            genericCommand.addParam(string);
            AddressNotificationService.this.broadcastToSlices(genericCommand);
        }
    }
}

