/*
 * Decompiled with CFR 0.152.
 */
package jade.domain;

import jade.content.AgentAction;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.Agent;
import jade.domain.FIPAAgentManagement.Deregister;
import jade.domain.FIPAAgentManagement.FIPAManagementOntology;
import jade.domain.FIPAAgentManagement.Modify;
import jade.domain.FIPAAgentManagement.Register;
import jade.domain.FIPAAgentManagement.Search;
import jade.domain.FIPAAgentManagement.SearchConstraints;
import jade.domain.FIPAAgentManagement.UnrecognisedValue;
import jade.domain.FIPAAgentManagement.UnsupportedFunction;
import jade.domain.FIPAException;
import jade.domain.FIPAService;
import jade.lang.acl.ACLMessage;
import jade.proto.SimpleAchieveREInitiator;
import jade.util.leap.List;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;

public class RequestFIPAServiceBehaviour
extends SimpleAchieveREInitiator {
    private ACLMessage lastMsg;
    private boolean notYetReady;
    private long timeout = 300000L;
    private FIPAException outcome = null;

    public RequestFIPAServiceBehaviour(Agent agent, AID aID, String string, Object object, SearchConstraints searchConstraints) throws FIPAException {
        super(agent, new ACLMessage(16));
        AgentAction agentAction;
        ACLMessage aCLMessage = FIPAService.createRequestMessage(agent, aID);
        Action action = new Action();
        action.setActor(aID);
        if (string.equalsIgnoreCase("register")) {
            agentAction = new Register();
            ((Register)agentAction).setDescription(object);
            action.setAction(agentAction);
        } else if (string.equalsIgnoreCase("deregister")) {
            agentAction = new Deregister();
            ((Deregister)agentAction).setDescription(object);
            action.setAction(agentAction);
        } else if (string.equalsIgnoreCase("modify")) {
            agentAction = new Modify();
            ((Modify)agentAction).setDescription(object);
            action.setAction(agentAction);
        } else if (string.equalsIgnoreCase("search")) {
            agentAction = new Search();
            ((Search)agentAction).setDescription(object);
            ((Search)agentAction).setConstraints(searchConstraints);
            action.setAction(agentAction);
            aCLMessage.setReplyByDate(new Date(System.currentTimeMillis() + this.timeout));
        } else {
            throw new UnsupportedFunction();
        }
        if (agent.getContentManager().lookupOntology("FIPA-Agent-Management") == null) {
            agent.getContentManager().registerOntology(FIPAManagementOntology.getInstance());
        }
        if (agent.getContentManager().lookupLanguage("fipa-sl0") == null) {
            agent.getContentManager().registerLanguage(new SLCodec(0), "fipa-sl0");
        }
        try {
            agent.getContentManager().fillContent(aCLMessage, action);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new UnrecognisedValue("content");
        }
        this.reset(aCLMessage);
        this.notYetReady = true;
    }

    public RequestFIPAServiceBehaviour(Agent agent, AID aID, String string, Object object) throws FIPAException {
        this(agent, aID, string, object, new SearchConstraints());
    }

    protected void handleNotUnderstood(ACLMessage aCLMessage) {
        this.notYetReady = false;
        this.lastMsg = (ACLMessage)aCLMessage.clone();
    }

    protected void handleRefuse(ACLMessage aCLMessage) {
        this.notYetReady = false;
        this.lastMsg = (ACLMessage)aCLMessage.clone();
    }

    protected void handleAgree(ACLMessage aCLMessage) {
    }

    protected void handleFailure(ACLMessage aCLMessage) {
        this.notYetReady = false;
        this.lastMsg = (ACLMessage)aCLMessage.clone();
    }

    protected void handleInform(ACLMessage aCLMessage) {
        this.notYetReady = false;
        this.lastMsg = (ACLMessage)aCLMessage.clone();
    }

    protected void handleOutOfSequence(ACLMessage aCLMessage) {
        this.notYetReady = false;
        this.lastMsg = (ACLMessage)aCLMessage.clone();
    }

    protected void handleAllResponses(Vector vector) {
        this.notYetReady = false;
        this.lastMsg = vector.size() == 0 ? new ACLMessage(10) : (ACLMessage)((ACLMessage)vector.elementAt(0)).clone();
    }

    public ACLMessage getLastMsg() throws FIPAException, NotYetReady {
        if (this.notYetReady) {
            throw new NotYetReady();
        }
        if (this.lastMsg.getPerformative() != 7) {
            throw new FIPAException(this.lastMsg);
        }
        return this.lastMsg;
    }

    public java.util.List getSearchResult() throws FIPAException, NotYetReady {
        Object[] objectArray = this.getSearchResults();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < objectArray.length) {
            arrayList.add(objectArray[n]);
            ++n;
        }
        return arrayList;
    }

    public Object[] getSearchResults() throws FIPAException, NotYetReady {
        if (this.notYetReady) {
            throw new NotYetReady();
        }
        if (this.lastMsg.getPerformative() != 7) {
            throw new FIPAException(this.lastMsg);
        }
        List list = null;
        try {
            Result result = (Result)this.myAgent.getContentManager().extractContent(this.lastMsg);
            list = result.getItems();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new UnrecognisedValue("content");
        }
        return list.toArray();
    }

    public static class NotYetReady
    extends Exception {
        NotYetReady() {
            super("Requested message is not ready yet.");
        }
    }
}

