/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.rmi;

import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.core.ServiceException;
import jade.imtp.rmi.NodeAdapter;
import jade.imtp.rmi.NodeRMI;
import jade.imtp.rmi.RMIIMTPManager;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

class NodeRMIImpl
extends UnicastRemoteObject
implements NodeRMI {
    private Object terminationLock = new Object();
    private boolean terminating = false;
    private NodeAdapter myNode;

    public NodeRMIImpl(NodeAdapter nodeAdapter, int n, RMIIMTPManager rMIIMTPManager) throws RemoteException {
        super(n, rMIIMTPManager.getClientSocketFactory(), rMIIMTPManager.getServerSocketFactory());
        this.myNode = nodeAdapter;
    }

    public Object accept(HorizontalCommand horizontalCommand) throws RemoteException, IMTPException {
        try {
            if (this.terminating) {
                throw new IMTPException("Dead node");
            }
            return this.myNode.serveHorizontalCommand(horizontalCommand);
        }
        catch (ServiceException serviceException) {
            throw new IMTPException("Service Error", serviceException);
        }
    }

    public void platformManagerDead(String string, String string2) throws RemoteException, IMTPException {
        if (this.terminating) {
            throw new IMTPException("Dead node");
        }
        this.myNode.platformManagerDead(string, string2);
    }

    public boolean ping(boolean bl) throws RemoteException {
        if (bl) {
            this.waitTermination();
        }
        return this.terminating;
    }

    public void exit() throws RemoteException {
        this.terminating = true;
        this.notifyTermination();
    }

    public void interrupt() throws RemoteException {
        this.notifyTermination();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitTermination() {
        Object object = this.terminationLock;
        synchronized (object) {
            try {
                this.terminationLock.wait();
            }
            catch (InterruptedException interruptedException) {
                System.out.println("PING wait interrupted");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTermination() {
        Object object = this.terminationLock;
        synchronized (object) {
            this.terminationLock.notifyAll();
        }
    }
}

