/*
 * Decompiled with CFR 0.152.
 */
package jade.proto;

import jade.core.Agent;
import jade.core.CaseInsensitiveString;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.FSMBehaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.core.behaviours.SimpleBehaviour;
import jade.domain.FIPAAgentManagement.FailureException;
import jade.domain.FIPAAgentManagement.NotUnderstoodException;
import jade.domain.FIPAAgentManagement.RefuseException;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.states.MsgReceiver;
import jade.proto.states.ReplySender;
import jade.proto.states.StateResetter;
import java.util.Date;

public class ContractNetResponder
extends FSMBehaviour {
    private static final String RESET_STATE = "Reset_state";
    private static final String RECEIVE_CFP_STATE = "Receive-CallForProposal";
    private static final String PREPARE_PROPOSE_STATE = "Prepare-Propose";
    private static final String SEND_PROPOSE_STATE = "Send-response";
    private static final String WAIT_ACCEPTANCE_STATE = "Wait-Acceptance";
    private static final String HANDLE_REJECT_STATE = "Handle-Reject";
    private static final String PREPARE_RESULT_NOTIFICATION_STATE = "Prepare-result-notification";
    private static final String SEND_RESULT_NOTIFICATION_STATE = "Send-result-notification";
    private static final String HANDLE_OUT_OF_SEQUENCE_STATE = "Handle-Out-Of-Sequence";
    public final String CFP_KEY = "__CFP_key" + this.hashCode();
    public final String RESPONSE_KEY;
    public final String PROPOSE_KEY = this.RESPONSE_KEY = "__Response" + this.hashCode();
    public final String PROPOSE_ACCEPTANCE_KEY = "___propose_acceptance" + this.hashCode();
    public final String RESULT_NOTIFICATION_KEY = "__result-notification" + this.hashCode();

    private ContractNetResponder() {
    }

    public ContractNetResponder(Agent agent, MessageTemplate messageTemplate) {
        this(agent, messageTemplate, new DataStore());
    }

    public ContractNetResponder(Agent agent, MessageTemplate messageTemplate, DataStore dataStore) {
        super(agent);
        this.setDataStore(dataStore);
        this.registerDefaultTransition(RECEIVE_CFP_STATE, PREPARE_PROPOSE_STATE);
        this.registerDefaultTransition(PREPARE_PROPOSE_STATE, SEND_PROPOSE_STATE);
        this.registerTransition(SEND_PROPOSE_STATE, WAIT_ACCEPTANCE_STATE, 11);
        this.registerTransition(WAIT_ACCEPTANCE_STATE, HANDLE_REJECT_STATE, 15);
        this.registerTransition(WAIT_ACCEPTANCE_STATE, HANDLE_REJECT_STATE, -1001);
        this.registerTransition(WAIT_ACCEPTANCE_STATE, PREPARE_RESULT_NOTIFICATION_STATE, 0);
        this.registerDefaultTransition(WAIT_ACCEPTANCE_STATE, HANDLE_OUT_OF_SEQUENCE_STATE);
        this.registerDefaultTransition(PREPARE_RESULT_NOTIFICATION_STATE, SEND_RESULT_NOTIFICATION_STATE);
        this.registerDefaultTransition(SEND_PROPOSE_STATE, RESET_STATE);
        this.registerDefaultTransition(HANDLE_REJECT_STATE, RESET_STATE);
        this.registerDefaultTransition(HANDLE_OUT_OF_SEQUENCE_STATE, RESET_STATE);
        this.registerDefaultTransition(SEND_RESULT_NOTIFICATION_STATE, RESET_STATE);
        SimpleBehaviour simpleBehaviour = new StateResetter();
        this.registerState(simpleBehaviour, RESET_STATE);
        simpleBehaviour = new MsgReceiver(this.myAgent, messageTemplate, -1L, this.getDataStore(), this.CFP_KEY);
        this.registerFirstState(simpleBehaviour, RECEIVE_CFP_STATE);
        simpleBehaviour = new PreparePropose(this.myAgent);
        this.registerDSState(simpleBehaviour, PREPARE_PROPOSE_STATE);
        simpleBehaviour = new ReplySender(this.myAgent, this.RESPONSE_KEY, this.CFP_KEY);
        this.registerDSState(simpleBehaviour, SEND_PROPOSE_STATE);
        simpleBehaviour = new AcceptReceiver(this.myAgent, messageTemplate, -1L, this.getDataStore(), this.PROPOSE_ACCEPTANCE_KEY);
        this.registerDSState(simpleBehaviour, WAIT_ACCEPTANCE_STATE);
        simpleBehaviour = new PrepareResult(this.myAgent);
        this.registerDSState(simpleBehaviour, PREPARE_RESULT_NOTIFICATION_STATE);
        simpleBehaviour = new ReplySender(this.myAgent, this.RESULT_NOTIFICATION_KEY, this.PROPOSE_ACCEPTANCE_KEY);
        this.registerDSState(simpleBehaviour, SEND_RESULT_NOTIFICATION_STATE);
        simpleBehaviour = new OneShotBehaviour(this.myAgent){

            public void action() {
                DataStore dataStore = this.getDataStore();
                ACLMessage aCLMessage = (ACLMessage)dataStore.get(ContractNetResponder.this.CFP_KEY);
                ACLMessage aCLMessage2 = (ACLMessage)dataStore.get(ContractNetResponder.this.RESPONSE_KEY);
                ACLMessage aCLMessage3 = (ACLMessage)dataStore.get(ContractNetResponder.this.PROPOSE_ACCEPTANCE_KEY);
                ContractNetResponder.this.handleRejectProposal(aCLMessage, aCLMessage2, aCLMessage3);
            }
        };
        this.registerDSState(simpleBehaviour, HANDLE_REJECT_STATE);
        simpleBehaviour = new OneShotBehaviour(this.myAgent){

            public void action() {
                DataStore dataStore = this.getDataStore();
                ACLMessage aCLMessage = (ACLMessage)dataStore.get(ContractNetResponder.this.CFP_KEY);
                ACLMessage aCLMessage2 = (ACLMessage)dataStore.get(ContractNetResponder.this.RESPONSE_KEY);
                ACLMessage aCLMessage3 = (ACLMessage)dataStore.get(ContractNetResponder.this.PROPOSE_ACCEPTANCE_KEY);
                ContractNetResponder.this.handleOutOfSequence(aCLMessage, aCLMessage2, aCLMessage3);
            }
        };
        this.registerDSState(simpleBehaviour, HANDLE_OUT_OF_SEQUENCE_STATE);
    }

    protected void handleRejectProposal(ACLMessage aCLMessage, ACLMessage aCLMessage2, ACLMessage aCLMessage3) {
    }

    protected void handleOutOfSequence(ACLMessage aCLMessage, ACLMessage aCLMessage2, ACLMessage aCLMessage3) {
    }

    protected ACLMessage prepareResultNotification(ACLMessage aCLMessage, ACLMessage aCLMessage2, ACLMessage aCLMessage3) throws FailureException {
        System.out.println("prepareResultNotification() method not re-defined");
        return null;
    }

    public void registerHandleRejectProposal(Behaviour behaviour) {
        this.registerDSState(behaviour, HANDLE_REJECT_STATE);
    }

    public void registerPrepareResponse(Behaviour behaviour) {
        this.registerDSState(behaviour, PREPARE_PROPOSE_STATE);
    }

    public void registerPrepareResultNotification(Behaviour behaviour) {
        this.registerDSState(behaviour, PREPARE_RESULT_NOTIFICATION_STATE);
    }

    public void registerHandleOutOfSequnece(Behaviour behaviour) {
        this.registerDSState(behaviour, HANDLE_OUT_OF_SEQUENCE_STATE);
    }

    public static MessageTemplate createMessageTemplate(String string) {
        if (CaseInsensitiveString.equalsIgnoreCase("fipa-iterated-contract-net", string)) {
            return MessageTemplate.and(MessageTemplate.MatchProtocol("fipa-iterated-contract-net"), MessageTemplate.MatchPerformative(3));
        }
        if (CaseInsensitiveString.equalsIgnoreCase("fipa-contract-net", string)) {
            return MessageTemplate.and(MessageTemplate.MatchProtocol("fipa-contract-net"), MessageTemplate.MatchPerformative(3));
        }
        return MessageTemplate.MatchProtocol(string);
    }

    protected ACLMessage prepareResponse(ACLMessage aCLMessage) throws NotUnderstoodException, RefuseException {
        System.out.println("prepareResponse() method not re-defined");
        return null;
    }

    public void reset() {
        super.reset();
        DataStore dataStore = this.getDataStore();
        dataStore.remove(this.CFP_KEY);
        dataStore.remove(this.PROPOSE_ACCEPTANCE_KEY);
        dataStore.remove(this.RESPONSE_KEY);
        dataStore.remove(this.RESULT_NOTIFICATION_KEY);
    }

    public void reset(MessageTemplate messageTemplate) {
        this.reset();
        MsgReceiver msgReceiver = (MsgReceiver)this.getState(RECEIVE_CFP_STATE);
        msgReceiver.reset(messageTemplate, -1L, this.getDataStore(), this.CFP_KEY);
        MsgReceiver msgReceiver2 = (MsgReceiver)this.getState(WAIT_ACCEPTANCE_STATE);
        msgReceiver2.reset(messageTemplate, -1L, this.getDataStore(), this.PROPOSE_ACCEPTANCE_KEY);
    }

    private void registerDSState(Behaviour behaviour, String string) {
        behaviour.setDataStore(this.getDataStore());
        this.registerState(behaviour, string);
    }

    private static class PrepareResult
    extends OneShotBehaviour {
        public PrepareResult(Agent agent) {
            super(agent);
        }

        public void action() {
            ContractNetResponder contractNetResponder = (ContractNetResponder)this.getParent();
            DataStore dataStore = this.getDataStore();
            ACLMessage aCLMessage = (ACLMessage)dataStore.get(contractNetResponder.CFP_KEY);
            ACLMessage aCLMessage2 = (ACLMessage)dataStore.get(contractNetResponder.RESPONSE_KEY);
            ACLMessage aCLMessage3 = (ACLMessage)dataStore.get(contractNetResponder.PROPOSE_ACCEPTANCE_KEY);
            ACLMessage aCLMessage4 = null;
            try {
                aCLMessage4 = contractNetResponder.prepareResultNotification(aCLMessage, aCLMessage2, aCLMessage3);
            }
            catch (FailureException failureException) {
                aCLMessage4 = failureException.getACLMessage();
            }
            dataStore.put(contractNetResponder.RESULT_NOTIFICATION_KEY, aCLMessage4);
        }

        private PrepareResult() {
        }
    }

    private static class AcceptReceiver
    extends MsgReceiver {
        public AcceptReceiver(Agent agent, MessageTemplate messageTemplate, long l, DataStore dataStore, Object object) {
            super(agent, messageTemplate, l, dataStore, object);
        }

        private AcceptReceiver() {
        }

        public void onStart() {
            ContractNetResponder contractNetResponder = (ContractNetResponder)this.getParent();
            DataStore dataStore = this.getDataStore();
            ACLMessage aCLMessage = (ACLMessage)dataStore.get(contractNetResponder.RESPONSE_KEY);
            if (aCLMessage == null) {
                return;
            }
            Date date = aCLMessage.getReplyByDate();
            long l = date == null ? -1L : date.getTime();
            MessageTemplate messageTemplate = MessageTemplate.and(MessageTemplate.MatchConversationId(aCLMessage.getConversationId()), MessageTemplate.MatchInReplyTo(aCLMessage.getReplyWith()));
            this.setDeadline(l);
            this.setTemplate(messageTemplate);
        }
    }

    private static class PreparePropose
    extends OneShotBehaviour {
        public PreparePropose(Agent agent) {
            super(agent);
        }

        private PreparePropose() {
        }

        public void action() {
            ContractNetResponder contractNetResponder = (ContractNetResponder)this.getParent();
            DataStore dataStore = this.getDataStore();
            ACLMessage aCLMessage = (ACLMessage)dataStore.get(contractNetResponder.CFP_KEY);
            ACLMessage aCLMessage2 = null;
            try {
                aCLMessage2 = contractNetResponder.prepareResponse(aCLMessage);
            }
            catch (NotUnderstoodException notUnderstoodException) {
                aCLMessage2 = notUnderstoodException.getACLMessage();
            }
            catch (RefuseException refuseException) {
                aCLMessage2 = refuseException.getACLMessage();
            }
            dataStore.put(contractNetResponder.RESPONSE_KEY, aCLMessage2);
        }
    }
}

