/*
 * Decompiled with CFR 0.152.
 */
package jade.proto;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.FSMBehaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.states.MsgReceiver;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.Map;
import java.util.Vector;

abstract class Initiator
extends FSMBehaviour {
    protected final String INITIATION_K = "__initiation" + this.hashCode();
    protected final String ALL_INITIATIONS_K = "__all-initiations" + this.hashCode();
    protected final String REPLY_K = "__reply" + this.hashCode();
    protected static final String PREPARE_INITIATIONS = "Prepare-initiations";
    protected static final String SEND_INITIATIONS = "Send-initiations";
    protected static final String RECEIVE_REPLY = "Receive-reply";
    protected static final String CHECK_IN_SEQ = "Check-in-seq";
    protected static final String HANDLE_NOT_UNDERSTOOD = "Handle-not-understood";
    protected static final String HANDLE_FAILURE = "Handle-failure";
    protected static final String HANDLE_OUT_OF_SEQ = "Handle-out-of-seq";
    protected static final String CHECK_SESSIONS = "Check-sessions";
    protected static final String DUMMY_FINAL = "Dummy-final";
    protected Map sessions = new HashMap();
    protected MsgReceiver replyReceiver = null;
    protected MessageTemplate replyTemplate = null;
    private ACLMessage initiation;

    protected Initiator(Agent agent, ACLMessage aCLMessage) {
        this(agent, aCLMessage, new DataStore());
    }

    protected Initiator(Agent agent, ACLMessage aCLMessage, DataStore dataStore) {
        super(agent);
        this.setDataStore(dataStore);
        this.initiation = aCLMessage;
        this.registerDefaultTransition(PREPARE_INITIATIONS, SEND_INITIATIONS);
        this.registerTransition(SEND_INITIATIONS, DUMMY_FINAL, 0);
        this.registerDefaultTransition(SEND_INITIATIONS, RECEIVE_REPLY);
        this.registerTransition(RECEIVE_REPLY, CHECK_SESSIONS, -1001);
        this.registerTransition(RECEIVE_REPLY, CHECK_SESSIONS, -1002);
        this.registerDefaultTransition(RECEIVE_REPLY, CHECK_IN_SEQ);
        this.registerTransition(CHECK_IN_SEQ, HANDLE_NOT_UNDERSTOOD, 10);
        this.registerTransition(CHECK_IN_SEQ, HANDLE_FAILURE, 6);
        this.registerDefaultTransition(CHECK_IN_SEQ, HANDLE_OUT_OF_SEQ);
        this.registerDefaultTransition(HANDLE_NOT_UNDERSTOOD, CHECK_SESSIONS);
        this.registerDefaultTransition(HANDLE_FAILURE, CHECK_SESSIONS);
        this.registerDefaultTransition(HANDLE_OUT_OF_SEQ, RECEIVE_REPLY);
        this.registerDefaultTransition(CHECK_SESSIONS, RECEIVE_REPLY, this.getToBeReset());
        OneShotBehaviour oneShotBehaviour = null;
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 3487495895818000L;

            public void action() {
                DataStore dataStore = this.getDataStore();
                Vector vector = (Vector)dataStore.get(Initiator.this.ALL_INITIATIONS_K);
                if (vector == null || vector.size() == 0) {
                    vector = Initiator.this.prepareInitiations((ACLMessage)dataStore.get(Initiator.this.INITIATION_K));
                    dataStore.put(Initiator.this.ALL_INITIATIONS_K, vector);
                }
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerFirstState(oneShotBehaviour, PREPARE_INITIATIONS);
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 3487495895818001L;

            public void action() {
                Vector vector = (Vector)this.getDataStore().get(Initiator.this.ALL_INITIATIONS_K);
                if (vector != null) {
                    Initiator.this.sendInitiations(vector);
                }
            }

            public int onEnd() {
                return Initiator.this.sessions.size();
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, SEND_INITIATIONS);
        this.replyReceiver = new MsgReceiver(this.myAgent, null, -1L, this.getDataStore(), this.REPLY_K);
        this.registerState(this.replyReceiver, RECEIVE_REPLY);
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){
            int ret;
            private static final long serialVersionUID = 3487495895818002L;

            public void action() {
                ACLMessage aCLMessage = (ACLMessage)this.getDataStore().get(Initiator.this.REPLY_K);
                this.ret = Initiator.this.checkInSequence(aCLMessage) ? aCLMessage.getPerformative() : -1;
            }

            public int onEnd() {
                return this.ret;
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, CHECK_IN_SEQ);
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 3487495895818005L;

            public void action() {
                Initiator.this.handleNotUnderstood((ACLMessage)this.getDataStore().get(Initiator.this.REPLY_K));
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, HANDLE_NOT_UNDERSTOOD);
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 3487495895818007L;

            public void action() {
                Initiator.this.handleFailure((ACLMessage)this.getDataStore().get(Initiator.this.REPLY_K));
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, HANDLE_FAILURE);
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 3487495895818008L;

            public void action() {
                Initiator.this.handleOutOfSequence((ACLMessage)this.getDataStore().get(Initiator.this.REPLY_K));
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, HANDLE_OUT_OF_SEQ);
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){
            int ret;
            private static final long serialVersionUID = 3487495895818009L;

            public void action() {
                ACLMessage aCLMessage = (ACLMessage)this.getDataStore().get(Initiator.this.REPLY_K);
                this.ret = Initiator.this.checkSessions(aCLMessage);
            }

            public int onEnd() {
                return this.ret;
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, CHECK_SESSIONS);
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 3487495895818010L;

            public void action() {
            }
        };
        this.registerLastState(oneShotBehaviour, DUMMY_FINAL);
    }

    protected abstract Vector prepareInitiations(ACLMessage var1);

    protected abstract void sendInitiations(Vector var1);

    protected abstract boolean checkInSequence(ACLMessage var1);

    protected abstract int checkSessions(ACLMessage var1);

    protected abstract String[] getToBeReset();

    protected void handleNotUnderstood(ACLMessage aCLMessage) {
    }

    protected void handleFailure(ACLMessage aCLMessage) {
    }

    protected void handleOutOfSequence(ACLMessage aCLMessage) {
    }

    protected void registerPrepareInitiations(Behaviour behaviour) {
        this.registerState(behaviour, PREPARE_INITIATIONS);
        behaviour.setDataStore(this.getDataStore());
    }

    public void registerHandleNotUnderstood(Behaviour behaviour) {
        this.registerState(behaviour, HANDLE_NOT_UNDERSTOOD);
        behaviour.setDataStore(this.getDataStore());
    }

    public void registerHandleFailure(Behaviour behaviour) {
        this.registerState(behaviour, HANDLE_FAILURE);
        behaviour.setDataStore(this.getDataStore());
    }

    public void registerHandleOutOfSequence(Behaviour behaviour) {
        this.registerState(behaviour, HANDLE_OUT_OF_SEQ);
        behaviour.setDataStore(this.getDataStore());
    }

    public void reset() {
        this.reset(null);
    }

    public void reset(ACLMessage aCLMessage) {
        super.reset();
        this.replyReceiver.reset(null, -1L, this.getDataStore(), this.REPLY_K);
        this.initiation = aCLMessage;
        this.sessions.clear();
        DataStore dataStore = this.getDataStore();
        dataStore.remove(this.INITIATION_K);
        dataStore.remove(this.ALL_INITIATIONS_K);
        dataStore.remove(this.REPLY_K);
    }

    public void onStart() {
        this.initializeDataStore(this.initiation);
    }

    public void setDataStore(DataStore dataStore) {
        super.setDataStore(dataStore);
        Iterator iterator = this.getChildren().iterator();
        while (iterator.hasNext()) {
            Behaviour behaviour = (Behaviour)iterator.next();
            behaviour.setDataStore(dataStore);
        }
    }

    protected void initializeDataStore(ACLMessage aCLMessage) {
        this.getDataStore().put(this.INITIATION_K, aCLMessage);
    }

    protected String createConvId(Vector vector) {
        String string = null;
        if (vector.size() > 0) {
            ACLMessage aCLMessage = (ACLMessage)vector.elementAt(0);
            string = aCLMessage == null || aCLMessage.getConversationId() == null ? "C" + this.hashCode() + "_" + System.currentTimeMillis() : aCLMessage.getConversationId();
        }
        return string;
    }

    protected void adjustReplyTemplate(ACLMessage aCLMessage) {
        AID aID = (AID)aCLMessage.getAllReceiver().next();
        if (this.myAgent.getAID().equals(aID)) {
            this.replyTemplate = MessageTemplate.and(this.replyTemplate, MessageTemplate.not(MessageTemplate.MatchCustom(aCLMessage, true)));
        }
    }
}

