/*
 * Decompiled with CFR 0.152.
 */
package jade.proto;

import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.FSMBehaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.core.behaviours.SimpleBehaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.states.MsgReceiver;
import jade.proto.states.ReplySender;
import java.util.Date;

abstract class Responder
extends FSMBehaviour {
    public final String RECEIVED_KEY = "__Received_key" + this.hashCode();
    public final String REPLY_KEY = "__Reply_key" + this.hashCode();
    protected static final String RECEIVE_INITIATION = "Receive-Initiation";
    protected static final String RECEIVE_NEXT = "Receive-Next";
    protected static final String HANDLE_OUT_OF_SEQUENCE = "Handle-Out-of-seq";
    protected static final String CHECK_IN_SEQ = "Check-In-seq";
    protected static final String SEND_REPLY = "Send-Reply";

    public Responder(Agent agent, MessageTemplate messageTemplate) {
        this(agent, messageTemplate, new DataStore());
    }

    public Responder(Agent agent, MessageTemplate messageTemplate, DataStore dataStore) {
        super(agent);
        this.setDataStore(dataStore);
        this.registerDefaultTransition(RECEIVE_INITIATION, CHECK_IN_SEQ);
        this.registerDefaultTransition(RECEIVE_NEXT, CHECK_IN_SEQ);
        this.registerDefaultTransition(CHECK_IN_SEQ, HANDLE_OUT_OF_SEQUENCE);
        this.registerDefaultTransition(HANDLE_OUT_OF_SEQUENCE, RECEIVE_NEXT, new String[]{HANDLE_OUT_OF_SEQUENCE});
        SimpleBehaviour simpleBehaviour = new CfpReceiver(this.myAgent, messageTemplate, -1L, this.getDataStore(), this.RECEIVED_KEY);
        this.registerFirstState(simpleBehaviour, RECEIVE_INITIATION);
        simpleBehaviour = new NextReceiver(this.myAgent, null, -1L, this.getDataStore(), this.RECEIVED_KEY);
        this.registerState(simpleBehaviour, RECEIVE_NEXT);
        simpleBehaviour = new CheckInSeq(this.myAgent);
        this.registerDSState(simpleBehaviour, CHECK_IN_SEQ);
        simpleBehaviour = new HandleOutOfSeq(this.myAgent);
        this.registerDSState(simpleBehaviour, HANDLE_OUT_OF_SEQUENCE);
        simpleBehaviour = new SendReply(this.myAgent, this.REPLY_KEY, this.RECEIVED_KEY);
        this.registerDSState(simpleBehaviour, SEND_REPLY);
    }

    private Responder() {
    }

    protected void handleOutOfSequence(ACLMessage aCLMessage) {
    }

    public void registerHandleOutOfSequence(Behaviour behaviour) {
        this.registerDSState(behaviour, HANDLE_OUT_OF_SEQUENCE);
    }

    public void reset() {
        super.reset();
        DataStore dataStore = this.getDataStore();
        dataStore.remove(this.RECEIVED_KEY);
        dataStore.remove(this.REPLY_KEY);
    }

    protected abstract boolean checkInSequence(ACLMessage var1);

    protected void replySent(int n) {
    }

    protected void registerDSState(Behaviour behaviour, String string) {
        behaviour.setDataStore(this.getDataStore());
        this.registerState(behaviour, string);
    }

    private static class SendReply
    extends ReplySender {
        public SendReply(Agent agent, String string, String string2) {
            super(agent, string, string2);
        }

        private SendReply() {
        }

        public int onEnd() {
            int n = super.onEnd();
            Responder responder = (Responder)this.getParent();
            responder.replySent(n);
            return n;
        }
    }

    private static class HandleOutOfSeq
    extends OneShotBehaviour {
        private static final long serialVersionUID = 4487495895818005L;

        public HandleOutOfSeq(Agent agent) {
            super(agent);
        }

        private HandleOutOfSeq() {
        }

        public void action() {
            Responder responder = (Responder)this.getParent();
            responder.handleOutOfSequence((ACLMessage)this.getDataStore().get(responder.RECEIVED_KEY));
        }
    }

    private static class CheckInSeq
    extends OneShotBehaviour {
        private int ret;
        private static final long serialVersionUID = 4487495895818000L;

        public CheckInSeq(Agent agent) {
            super(agent);
        }

        private CheckInSeq() {
        }

        public void action() {
            ACLMessage aCLMessage;
            Responder responder = (Responder)this.getParent();
            this.ret = responder.checkInSequence(aCLMessage = (ACLMessage)this.getDataStore().get(responder.RECEIVED_KEY)) ? aCLMessage.getPerformative() : -1;
        }

        public int onEnd() {
            return this.ret;
        }
    }

    private static class NextReceiver
    extends MsgReceiver {
        public NextReceiver(Agent agent, MessageTemplate messageTemplate, long l, DataStore dataStore, Object object) {
            super(agent, messageTemplate, l, dataStore, object);
        }

        private NextReceiver() {
        }

        public void onStart() {
            Date date;
            Responder responder = (Responder)this.getParent();
            ACLMessage aCLMessage = (ACLMessage)this.getDataStore().get(responder.REPLY_KEY);
            if (aCLMessage != null && (date = aCLMessage.getReplyByDate()) != null && date.getTime() > System.currentTimeMillis()) {
                this.setDeadline(date.getTime());
            }
        }
    }

    private static class CfpReceiver
    extends MsgReceiver {
        public CfpReceiver(Agent agent, MessageTemplate messageTemplate, long l, DataStore dataStore, Object object) {
            super(agent, messageTemplate, l, dataStore, object);
        }

        private CfpReceiver() {
        }

        public int onEnd() {
            Responder responder = (Responder)this.getParent();
            MsgReceiver msgReceiver = (MsgReceiver)responder.getState(Responder.RECEIVE_NEXT);
            ACLMessage aCLMessage = (ACLMessage)this.getDataStore().get(responder.RECEIVED_KEY);
            msgReceiver.setTemplate(MessageTemplate.MatchConversationId(aCLMessage.getConversationId()));
            return super.onEnd();
        }
    }
}

