/*
 * Decompiled with CFR 0.152.
 */
package jade.wrapper;

import jade.core.AID;
import jade.core.Agent;
import jade.core.AgentContainer;
import jade.core.AgentManager;
import jade.core.MainContainer;
import jade.core.NotFoundException;
import jade.mtp.MTPException;
import jade.wrapper.AgentController;
import jade.wrapper.ContainerProxy;
import jade.wrapper.ControllerException;
import jade.wrapper.PlatformController;
import jade.wrapper.PlatformControllerImpl;
import jade.wrapper.StaleProxyException;

public class ContainerController {
    private AgentContainer myImpl;
    private ContainerProxy myProxy;
    private String myPlatformName;
    protected PlatformController myPlatformController;

    public ContainerController(ContainerProxy containerProxy, AgentContainer agentContainer, String string) {
        this.myProxy = containerProxy;
        this.myImpl = agentContainer;
        this.myPlatformName = string;
    }

    public AgentController getAgent(String string) throws ControllerException {
        if (this.myImpl == null || this.myProxy == null) {
            throw new StaleProxyException();
        }
        AID aID = new AID(string, false);
        Agent agent = this.myImpl.acquireLocalAgent(aID);
        if (agent == null) {
            throw new ControllerException("Agent " + string + " not found.");
        }
        this.myImpl.releaseLocalAgent(aID);
        return new AgentController(aID, this.myProxy, this.myImpl);
    }

    public AgentController createNewAgent(String string, String string2, Object[] objectArray) throws StaleProxyException {
        if (this.myImpl == null || this.myProxy == null) {
            throw new StaleProxyException();
        }
        AID aID = new AID(string, false);
        try {
            this.myProxy.createAgent(aID, string2, objectArray);
            return new AgentController(aID, this.myProxy, this.myImpl);
        }
        catch (Throwable throwable) {
            throw new StaleProxyException(throwable);
        }
    }

    public AgentController acceptNewAgent(String string, Agent agent) throws StaleProxyException {
        if (this.myImpl == null || this.myProxy == null) {
            throw new StaleProxyException();
        }
        AID aID = new AID(string, false);
        try {
            this.myImpl.initAgent(aID, agent, null, null);
        }
        catch (Exception exception) {
            throw new StaleProxyException(exception);
        }
        return new AgentController(aID, this.myProxy, this.myImpl);
    }

    public void kill() throws StaleProxyException {
        if (this.myImpl == null || this.myProxy == null) {
            throw new StaleProxyException();
        }
        try {
            this.myProxy.killContainer();
            this.myProxy = null;
            this.myImpl = null;
            this.myPlatformName = null;
        }
        catch (Throwable throwable) {
            throw new StaleProxyException(throwable);
        }
    }

    public void installMTP(String string, String string2) throws MTPException, StaleProxyException {
        if (this.myImpl == null || this.myProxy == null) {
            throw new StaleProxyException();
        }
        try {
            this.myProxy.installMTP(string, string2);
        }
        catch (Throwable throwable) {
            throw new StaleProxyException(throwable);
        }
    }

    public void uninstallMTP(String string) throws MTPException, NotFoundException, StaleProxyException {
        if (this.myImpl == null || this.myProxy == null) {
            throw new StaleProxyException();
        }
        try {
            this.myProxy.uninstallMTP(string);
        }
        catch (Throwable throwable) {
            throw new StaleProxyException(throwable);
        }
    }

    public String getPlatformName() {
        return this.myPlatformName;
    }

    public String getContainerName() throws ControllerException {
        if (this.myImpl == null) {
            throw new ControllerException("Stale proxy.");
        }
        return this.myImpl.here().getName();
    }

    public PlatformController getPlatformController() throws ControllerException {
        this.initPlatformController();
        return this.myPlatformController;
    }

    protected void initPlatformController() throws ControllerException {
        if (this.myPlatformController == null) {
            if (this.myImpl == null) {
                throw new ControllerException("Stale proxy.");
            }
            MainContainer mainContainer = this.myImpl.getMain();
            if (mainContainer == null) {
                throw new ControllerException("Not a Main Container.");
            }
            if (mainContainer instanceof AgentManager) {
                this.myPlatformController = new PlatformControllerImpl(this, (AgentManager)((Object)mainContainer));
            } else {
                throw new ControllerException("Platform not accessible.");
            }
        }
    }
}

