/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.SocketProxyAgent;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.ACLParser;
import jade.tools.SocketProxyAgent.SocketProxyAgent;
import jade.tools.SocketProxyAgent.WaitAnswersBehaviour;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

class Connection
extends Thread {
    private Agent myAgent;
    private Socket client;
    private DataInputStream in;
    private PrintStream out;
    private boolean done = false;
    private Vector myOnlyReceivers;

    Connection(Socket socket, Agent agent, Vector vector) {
        this.myAgent = agent;
        String string = this.myAgent.getLocalName() + "-ClientConnection-" + this.getName();
        string = string.trim().replace(' ', '_');
        this.setName(string);
        this.myAgent = agent;
        this.client = socket;
        this.myOnlyReceivers = vector;
        try {
            this.in = new DataInputStream(this.client.getInputStream());
            this.out = new PrintStream(this.client.getOutputStream(), true);
        }
        catch (IOException iOException) {
            try {
                this.client.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            iOException.printStackTrace();
            return;
        }
        this.start();
    }

    private boolean myOnlyReceiversContains(Iterator iterator) {
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            String string = ((AID)iterator.next()).getName();
            int n = string.lastIndexOf(64);
            if (n == -1) {
                string = string + "@" + this.myAgent.getHap();
            }
            ((SocketProxyAgent)this.myAgent).log("Requested addressee:" + string);
            arrayList.add(string);
        }
        int n = 0;
        while (n < this.myOnlyReceivers.size()) {
            String string = (String)this.myOnlyReceivers.elementAt(n);
            if (string.equals("*") || arrayList.contains(string)) {
                ((SocketProxyAgent)this.myAgent).log("Valid addressee:" + string);
                return true;
            }
            ++n;
        }
        ((SocketProxyAgent)this.myAgent).log("No valid addressee, message delivery will be refused.");
        return false;
    }

    public void run() {
        try {
            ACLParser aCLParser = new ACLParser((InputStream)this.in);
            this.done = false;
            while (!this.done) {
                if (aCLParser.token.kind != 0) {
                    ACLMessage aCLMessage = aCLParser.Message();
                    ((SocketProxyAgent)this.myAgent).log(this.getName() + ": Received message:" + aCLMessage);
                    if (this.myOnlyReceiversContains((Iterator)aCLMessage.getAllReceiver())) {
                        aCLMessage.setSender(this.myAgent.getAID());
                        if (aCLMessage.getReplyWith() == null || aCLMessage.getReplyWith().length() < 1) {
                            aCLMessage.setReplyWith(this.getName() + "." + System.currentTimeMillis());
                        }
                        if (aCLMessage.getInReplyTo() == null) {
                            aCLMessage.setInReplyTo("noValue");
                        }
                        this.myAgent.send(aCLMessage);
                        ((SocketProxyAgent)this.myAgent).log("Sent message to jade, awaiting reply for " + aCLMessage.getReplyWith());
                        this.myAgent.addBehaviour((Behaviour)new WaitAnswersBehaviour(this.myAgent, aCLMessage, this.out));
                        continue;
                    }
                    ((SocketProxyAgent)this.myAgent).log("About to send refusal");
                    this.out.println("(refuse :content unauthorised)");
                    this.out.flush();
                    this.done = true;
                    this.close(null);
                    return;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            this.close(throwable);
            return;
        }
    }

    protected void closeDown() {
        this.done = true;
        this.interrupt();
        this.close(null);
        try {
            this.join(1000L);
        }
        catch (InterruptedException interruptedException) {}
    }

    void close(Throwable throwable) {
        this.done = true;
        try {
            this.client.close();
            this.client = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }

    protected void finalize() {
        try {
            if (this.client != null) {
                this.client.close();
                this.client = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
        }
        catch (Exception exception) {}
    }
}

