/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.gui;

import jade.core.AID;
import jade.lang.acl.ACLMessage;
import jade.util.Logger;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.tree.DefaultMutableTreeNode;

public class ACLMessageNode
extends DefaultMutableTreeNode {
    private static DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);
    private Date theDate = new Date();
    private ACLMessage theMessage;
    private String direction;
    private String time;

    ACLMessageNode(String string) {
        super(string);
    }

    public ACLMessage getMessage() {
        return this.theMessage;
    }

    public String getPerformative() {
        return ACLMessage.getPerformative((int)this.theMessage.getPerformative());
    }

    public String getSendTo() {
        if (this.theMessage.getAllReceiver().hasNext()) {
            AID aID = (AID)this.theMessage.getAllReceiver().next();
            return aID.getName();
        }
        return "<unknown>";
    }

    public String getOntology() {
        String string = this.theMessage.getOntology();
        if (string != null) {
            return string;
        }
        return "<unknown>";
    }

    public String getDirection() {
        return this.direction;
    }

    public String getTime() {
        return this.time;
    }

    public Date getTheDate() {
        return this.theDate;
    }

    public void setMessage(ACLMessage aCLMessage) {
        this.theMessage = (ACLMessage)aCLMessage.clone();
    }

    public void setDirection(String string) {
        this.direction = string;
    }

    public void setTime(String string) {
        this.time = string;
        try {
            this.theDate = dateFormat.parse(this.time);
        }
        catch (Exception exception) {
            Logger.getMyLogger((String)this.getClass().getName()).log(Logger.WARNING, exception.getMessage());
        }
    }

    public void setTheDate(Date date) {
        this.theDate = date;
    }

    public String receivedFrom() {
        if (this.theMessage.getSender() != null) {
            AID aID = this.theMessage.getSender();
            return aID.getName();
        }
        return "<unknown>";
    }
}

