/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.base;

import aspmodificator.model.LineBase;
import aspmodificator.modificationrules.IModificationRule;
import aspmodificator.modificationrules.TabuList;
import aspmodificator.modificationrules.gringo.DeleteRuleModificationRule;
import aspmodificator.parser.gringo.GringoRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import main.RuleApplicationEnum;

public class ProgramModificator {
    protected Random random;
    private long seed = System.currentTimeMillis();
    private boolean writeComments = true;
    private RuleApplicationEnum ruleApplication;
    private boolean useMemory = true;
    private TabuList tabuList;

    public ProgramModificator() {
        this.random = new Random(this.seed);
        this.tabuList = new TabuList();
    }

    private List<LineBase> copyProgram(List<LineBase> parsedProgram) throws CloneNotSupportedException {
        ArrayList<LineBase> result = new ArrayList<LineBase>();
        for (LineBase line : parsedProgram) {
            if (GringoRule.class == line.getClass()) {
                result.add((LineBase)line.clone());
                continue;
            }
            result.add(line);
        }
        return result;
    }

    private int doModifications(List<IModificationRule> modificationRules, List<LineBase> copy) throws Exception {
        int modCount = 0;
        switch (this.ruleApplication) {
            case oneOfMany: {
                Collections.shuffle(modificationRules, this.random);
                for (IModificationRule modificationRule : modificationRules) {
                    modCount = modificationRule.apply(copy);
                    if (modCount <= 0) continue;
                    return modCount;
                }
                break;
            }
            default: {
                this.sortRules(modificationRules);
                for (IModificationRule modificationRule : modificationRules) {
                    modCount += modificationRule.apply(copy);
                }
            }
        }
        return modCount;
    }

    public long getSeed() {
        return this.seed;
    }

    public List<LineBase> modifyProgram(List<LineBase> parsedProgram, List<IModificationRule> modificationRules) throws Exception {
        if (modificationRules == null) {
            throw new NullPointerException("modificationRules must not be null");
        }
        List<LineBase> copy = this.copyProgram(parsedProgram);
        for (IModificationRule modificationRule : modificationRules) {
            modificationRule.setRandom(this.random);
            modificationRule.setWriteComments(this.writeComments);
            modificationRule.setUseMemory(this.useMemory);
            modificationRule.setTabuList(this.tabuList);
        }
        int noModifications = this.doModifications(modificationRules, copy);
        if (noModifications == 0) {
            return null;
        }
        return copy;
    }

    public void setRandomInitialization(long seed) {
        this.random.setSeed(seed);
    }

    public void setRuleApplication(RuleApplicationEnum ruleApplication) {
        this.ruleApplication = ruleApplication;
    }

    public void setUseMemory(boolean useMemory) {
        this.useMemory = useMemory;
    }

    public void setWriteComments(boolean writeComments) {
        this.writeComments = writeComments;
    }

    private void sortRules(List<IModificationRule> modificationRules) {
        ArrayList<IModificationRule> toInsertFirstList = new ArrayList<IModificationRule>();
        for (IModificationRule rule : modificationRules) {
            if (!(rule instanceof DeleteRuleModificationRule)) continue;
            toInsertFirstList.add(rule);
        }
        modificationRules.removeAll(toInsertFirstList);
        for (IModificationRule rule : toInsertFirstList) {
            modificationRules.add(0, rule);
        }
    }
}

