/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.modificationrules;

import aspmodificator.modificationrules.gringo.ModificationRuleTypeEnum;
import java.util.BitSet;
import java.util.EnumMap;
import java.util.HashMap;

public class TabuList {
    private EnumMap<ModificationRuleTypeEnum, HashMap<Integer, BitSet>> tabuList = new EnumMap(ModificationRuleTypeEnum.class);
    private EnumMap<ModificationRuleTypeEnum, HashMap<Integer, HashMap<Integer, BitSet>>> two_level_tabuList = new EnumMap(ModificationRuleTypeEnum.class);

    public boolean isTabu(ModificationRuleTypeEnum ruleType, int lineNo, int objectIndex) {
        if (!this.tabuList.containsKey((Object)ruleType)) {
            return false;
        }
        HashMap<Integer, BitSet> map = this.tabuList.get((Object)ruleType);
        BitSet bitSet = map.get(lineNo);
        if (bitSet == null) {
            return false;
        }
        return bitSet.get(objectIndex);
    }

    public boolean isTabu(ModificationRuleTypeEnum ruleType, int lineNo, int objectIndex, int choosenIndex) {
        if (!this.two_level_tabuList.containsKey((Object)ruleType)) {
            return false;
        }
        HashMap<Integer, HashMap<Integer, BitSet>> secondLevelMap = this.two_level_tabuList.get((Object)ruleType);
        if (!secondLevelMap.containsKey(lineNo)) {
            return false;
        }
        HashMap<Integer, BitSet> map = secondLevelMap.get(lineNo);
        BitSet bitSet = map.get(objectIndex);
        if (bitSet == null) {
            return false;
        }
        return bitSet.get(choosenIndex);
    }

    public void setTabu(ModificationRuleTypeEnum ruleType, int lineNo, int objectIndex) {
        BitSet bitSet;
        HashMap<Integer, BitSet> map = this.tabuList.get((Object)ruleType);
        if (map == null) {
            map = new HashMap();
            this.tabuList.put(ruleType, map);
        }
        if ((bitSet = map.get(lineNo)) == null) {
            bitSet = new BitSet();
            map.put(lineNo, bitSet);
        }
        bitSet.set(objectIndex);
    }

    public void setTabu(ModificationRuleTypeEnum ruleType, int lineNo, int objectIndex, int choosenIndex) {
        BitSet bitSet;
        HashMap<Integer, BitSet> tmpMap;
        HashMap<Integer, HashMap<Integer, BitSet>> map = this.two_level_tabuList.get((Object)ruleType);
        if (map == null) {
            map = new HashMap();
            this.two_level_tabuList.put(ruleType, map);
        }
        if ((tmpMap = map.get(lineNo)) == null) {
            tmpMap = new HashMap();
            map.put(lineNo, tmpMap);
        }
        if ((bitSet = tmpMap.get(objectIndex)) == null) {
            bitSet = new BitSet();
            tmpMap.put(objectIndex, bitSet);
        }
        bitSet.set(choosenIndex);
    }
}

