/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.modificationrules.gringo;

import aspmodificator.model.LineBase;
import aspmodificator.modificationrules.gringo.AbstractModificationRule;
import aspmodificator.parser.gringo.Literal;
import common.Pair;
import java.util.List;

public abstract class AbstractComplexLiteralModificationRule
extends AbstractModificationRule {
    public AbstractComplexLiteralModificationRule() {
    }

    public AbstractComplexLiteralModificationRule(int minApplication, int maxApplication) {
        super(minApplication, maxApplication);
    }

    @Override
    public int apply(List<LineBase> program) {
        List<Pair<Literal, Literal>> applicableObjectPairs = this.findApplicableObjects(program);
        if (applicableObjectPairs.size() == 0) {
            return 0;
        }
        int ruleApplied = 0;
        double chance = (double)(this.minApplication + this.maxApplication) / (double)(2 * applicableObjectPairs.size());
        int applicableObjectNo = applicableObjectPairs.size();
        block0: while (applicableObjectNo > 0 && ruleApplied < this.maxApplication && ruleApplied < this.minApplication) {
            applicableObjectNo = applicableObjectPairs.size();
            int objectIndex = -1;
            for (Pair<Literal, Literal> pair : applicableObjectPairs) {
                ++objectIndex;
                if (pair.getFirst().isModified()) {
                    --applicableObjectNo;
                    continue;
                }
                if (this.useMemory && this.tabuList.isTabu(this.getRuleTypeEnum(), pair.getFirst().getLineNo(), objectIndex)) {
                    --applicableObjectNo;
                    continue;
                }
                double randomValue = this.random.nextDouble();
                if (!(randomValue <= chance)) continue;
                Literal newLiteral = this.modifyLiteral(pair);
                int index = pair.getSecond().getTerms().indexOf(pair.getFirst());
                if (index >= 0) {
                    pair.getSecond().getTerms().remove(index);
                }
                if (newLiteral != null) {
                    pair.getSecond().getTerms().add(index, newLiteral);
                    newLiteral.setModified(true);
                }
                ++ruleApplied;
                --applicableObjectNo;
                if (this.useMemory) {
                    this.tabuList.setTabu(this.getRuleTypeEnum(), pair.getFirst().getLineNo(), objectIndex);
                }
                if (ruleApplied == this.maxApplication) continue block0;
            }
        }
        return ruleApplied;
    }

    protected abstract List<Pair<Literal, Literal>> findApplicableObjects(List<LineBase> var1);

    protected abstract Literal modifyLiteral(Pair<Literal, Literal> var1);
}

