/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.modificationrules.gringo;

import aspmodificator.model.LineBase;
import aspmodificator.modificationrules.gringo.AbstractModificationRule;
import aspmodificator.parser.gringo.Literal;
import java.util.List;

public abstract class AbstractLiteralModificationRule
extends AbstractModificationRule {
    public AbstractLiteralModificationRule() {
    }

    public AbstractLiteralModificationRule(int min, int max) {
        super(min, max);
    }

    @Override
    public int apply(List<LineBase> program) {
        List<Literal> applicableObject = this.findApplicableObjects(program);
        if (applicableObject.size() == 0) {
            return 0;
        }
        int ruleApplied = 0;
        double chance = (double)(this.minApplication + this.maxApplication) / (double)(2 * applicableObject.size());
        int applicableObjectNo = applicableObject.size();
        block0: while (applicableObjectNo > 0 && ruleApplied < this.maxApplication && ruleApplied < this.minApplication) {
            applicableObjectNo = applicableObject.size();
            int objectIndex = -1;
            for (Literal lit : applicableObject) {
                ++objectIndex;
                if (lit.isModified()) {
                    --applicableObjectNo;
                    continue;
                }
                if (this.useMemory && this.tabuList.isTabu(this.getRuleTypeEnum(), lit.getLineNo(), objectIndex)) {
                    --applicableObjectNo;
                    continue;
                }
                double randomValue = this.random.nextDouble();
                if (!(randomValue <= chance)) continue;
                this.modifyLiteral(lit);
                lit.setModified(true);
                ++ruleApplied;
                --applicableObjectNo;
                if (this.useMemory) {
                    this.tabuList.setTabu(this.getRuleTypeEnum(), lit.getLineNo(), objectIndex);
                }
                if (ruleApplied == this.maxApplication) continue block0;
            }
        }
        return ruleApplied;
    }

    protected abstract List<Literal> findApplicableObjects(List<LineBase> var1);

    protected abstract void modifyLiteral(Literal var1);
}

