/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.modificationrules.gringo;

import aspmodificator.model.LineBase;
import aspmodificator.modificationrules.gringo.AbstractModificationRule;
import aspmodificator.parser.gringo.Literal;
import common.Tripple;
import java.util.List;

public abstract class AbstractReplacementLiteralModificationRule<K>
extends AbstractModificationRule {
    public AbstractReplacementLiteralModificationRule() {
    }

    public AbstractReplacementLiteralModificationRule(int minApplication, int maxApplication) {
        super(minApplication, maxApplication);
    }

    @Override
    public int apply(List<LineBase> program) {
        List<Tripple<Literal, Literal, List<K>>> applicableObjectPairs = this.findApplicableObjects(program);
        if (applicableObjectPairs.size() == 0) {
            return 0;
        }
        int ruleApplied = 0;
        double chance = (double)(this.minApplication + this.maxApplication) / (double)(2 * applicableObjectPairs.size());
        int applicableObjectNo = applicableObjectPairs.size();
        block0: while (applicableObjectNo > 0 && ruleApplied < this.maxApplication && ruleApplied < this.minApplication) {
            applicableObjectNo = applicableObjectPairs.size();
            int objectIndex = -1;
            for (Tripple<Literal, Literal, List<K>> tripple : applicableObjectPairs) {
                ++objectIndex;
                if (tripple.getFirst().isModified()) {
                    --applicableObjectNo;
                    continue;
                }
                if (tripple.getThird().isEmpty()) {
                    --applicableObjectNo;
                    continue;
                }
                double randomValue = this.random.nextDouble();
                if (!(randomValue <= chance)) continue;
                int choosenIndex = this.random.nextInt(tripple.getThird().size());
                int tries = 0;
                int maxTries = tripple.getThird().size() * 2;
                while (this.useMemory && this.tabuList.isTabu(this.getRuleTypeEnum(), tripple.getFirst().getLineNo(), objectIndex, choosenIndex) && tries < maxTries) {
                    choosenIndex = this.random.nextInt(tripple.getThird().size());
                    ++tries;
                }
                if (this.useMemory && this.tabuList.isTabu(this.getRuleTypeEnum(), tripple.getFirst().getLineNo(), objectIndex, choosenIndex)) {
                    --applicableObjectNo;
                    continue;
                }
                Literal newLiteral = this.modifyLiteral(tripple, choosenIndex);
                if (newLiteral != tripple.getFirst()) {
                    int index = tripple.getSecond().getTerms().indexOf(tripple.getFirst());
                    if (index >= 0) {
                        tripple.getSecond().getTerms().remove(index);
                    }
                    if (newLiteral != null) {
                        tripple.getSecond().getTerms().add(index, newLiteral);
                    }
                }
                if (newLiteral != null) {
                    newLiteral.setModified(true);
                }
                ++ruleApplied;
                --applicableObjectNo;
                if (this.useMemory) {
                    this.tabuList.setTabu(this.getRuleTypeEnum(), tripple.getFirst().getLineNo(), objectIndex, choosenIndex);
                }
                if (ruleApplied == this.maxApplication) continue block0;
            }
        }
        return ruleApplied;
    }

    protected abstract List<Tripple<Literal, Literal, List<K>>> findApplicableObjects(List<LineBase> var1);

    protected abstract Literal modifyLiteral(Tripple<Literal, Literal, List<K>> var1, int var2);
}

