/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.modificationrules.gringo;

import aspmodificator.model.LineBase;
import aspmodificator.modificationrules.gringo.AbstractModificationRule;
import aspmodificator.parser.gringo.GringoRule;
import java.util.List;
import java.util.Random;

public abstract class AbstractRuleModificationRule
extends AbstractModificationRule {
    public AbstractRuleModificationRule() {
    }

    public AbstractRuleModificationRule(int minApplication, int maxApplication) {
        super(minApplication, maxApplication);
    }

    @Override
    public int apply(List<LineBase> program) throws Exception {
        List<GringoRule> applicableRules = this.findApplicableRules(program);
        if (applicableRules.size() == 0) {
            return 0;
        }
        int ruleApplied = 0;
        double chance = (double)(this.minApplication + this.maxApplication) / (double)(2 * applicableRules.size());
        int applicableObjectNo = applicableRules.size();
        block0: while (applicableObjectNo > 0 && ruleApplied < this.maxApplication && ruleApplied < this.minApplication) {
            applicableObjectNo = applicableRules.size();
            int objectIndex = -1;
            for (GringoRule rule : applicableRules) {
                ++objectIndex;
                if (rule.isModified()) {
                    --applicableObjectNo;
                    continue;
                }
                if (this.useMemory && this.tabuList.isTabu(this.getRuleTypeEnum(), 1, objectIndex)) {
                    --applicableObjectNo;
                    continue;
                }
                double randomValue = this.random.nextDouble();
                if (!(randomValue <= chance)) continue;
                this.modifyRule(rule);
                rule.setModified(true);
                ++ruleApplied;
                --applicableObjectNo;
                if (this.useMemory) {
                    this.tabuList.setTabu(this.getRuleTypeEnum(), 1, objectIndex);
                }
                if (ruleApplied == this.maxApplication) continue block0;
            }
        }
        return ruleApplied;
    }

    protected abstract List<GringoRule> findApplicableRules(List<LineBase> var1);

    protected abstract boolean modifyRule(GringoRule var1);

    @Override
    public void setRandom(Random rand) {
        this.random = rand;
    }
}

