/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.modificationrules.gringo;

import aspmodificator.model.LineBase;
import aspmodificator.modificationrules.gringo.GringoRuleUtil;
import aspmodificator.modificationrules.gringo.SwitchDefaultNegationModificationRule;
import aspmodificator.parser.gringo.GringoRule;
import aspmodificator.parser.gringo.Literal;
import java.util.ArrayList;
import java.util.List;

public class AddDefaultNegationModificationRule
extends SwitchDefaultNegationModificationRule {
    public AddDefaultNegationModificationRule() {
    }

    public AddDefaultNegationModificationRule(int minApplication, int maxApplication) {
        super(minApplication, maxApplication);
    }

    @Override
    protected List<Literal> findApplicableObjects(List<LineBase> program) {
        ArrayList<Literal> result = new ArrayList<Literal>();
        for (LineBase line : program) {
            GringoRule rule;
            if (!GringoRule.class.isAssignableFrom(line.getClass()) || (rule = (GringoRule)line).getBody() == null) continue;
            for (Literal lit : rule.getBody()) {
                if (!this.allowsDefaultNegation(lit.getClass()) || lit.isModified() || lit.isSigned()) continue;
                lit.setSigned(true);
                if (GringoRuleUtil.checkSafety(rule)) {
                    result.add(lit);
                }
                lit.setSigned(false);
            }
        }
        return result;
    }

    @Override
    protected void modifyLiteral(Literal lit) {
        lit.setSigned(true);
        if (this.writeComments) {
            lit.addSucceedingComment("%*ModificationNote: added default-negation \"not\" *%");
        }
    }
}

