/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.modificationrules.gringo;

import aspmodificator.model.LineBase;
import aspmodificator.modificationrules.gringo.AbstractLiteralModificationRule;
import aspmodificator.modificationrules.gringo.ModificationRuleTypeEnum;
import aspmodificator.modificationrules.gringo.RuleTargetEnum;
import aspmodificator.parser.gringo.AggregateLiteral;
import aspmodificator.parser.gringo.ConstTerm;
import aspmodificator.parser.gringo.GringoRule;
import aspmodificator.parser.gringo.Literal;
import aspmodificator.parser.gringo.MathTerm;
import aspmodificator.parser.gringo.Term;
import java.util.ArrayList;
import java.util.List;

public class AggregateLiteralModificationRule
extends AbstractLiteralModificationRule {
    public AggregateLiteralModificationRule() {
    }

    public AggregateLiteralModificationRule(int minApplication, int maxApplication) {
        super(minApplication, maxApplication);
    }

    private void bothInteger(Term lowerConstant, Term upperConstant, boolean modifyLower, boolean shouldIncrement) {
        boolean zeroValue;
        int lower = 1;
        int upper = 1;
        if (lowerConstant != null) {
            lower = Integer.parseInt(lowerConstant.getIdentifier());
        }
        if (upperConstant != null) {
            upper = Integer.parseInt(upperConstant.getIdentifier());
        }
        boolean sameValue = lower == upper;
        boolean bl = zeroValue = lower == 0;
        if (modifyLower && !shouldIncrement && zeroValue) {
            shouldIncrement = true;
        }
        if (modifyLower && shouldIncrement && sameValue && zeroValue) {
            modifyLower = false;
        }
        if (modifyLower) {
            if (sameValue || !shouldIncrement) {
                lowerConstant.setIdentifier(Integer.toString(lower - 1));
                if (this.writeComments) {
                    lowerConstant.addSucceedingComment("%* ModificationNote: lower value has been decreased. Original value was " + lower + "  *%");
                }
            } else {
                lowerConstant.setIdentifier(Integer.toString(lower + 1));
                if (this.writeComments) {
                    lowerConstant.addSucceedingComment("%* ModificationNote: lower value has been increased. Original value was " + lower + "  *%");
                }
            }
        } else if (sameValue || shouldIncrement) {
            upperConstant.setIdentifier(Integer.toString(upper + 1));
            if (this.writeComments) {
                lowerConstant.addSucceedingComment("%* ModificationNote: upper value has been increased. Original value was " + upper + "  *%");
            }
        } else {
            upperConstant.setIdentifier(Integer.toString(upper - 1));
            if (this.writeComments) {
                lowerConstant.addSucceedingComment("%* ModificationNote: upper value has been decreased. Original value was " + upper + "  *%");
            }
        }
    }

    @Override
    protected List<Literal> findApplicableObjects(List<LineBase> program) {
        ArrayList<Literal> result = new ArrayList<Literal>();
        for (LineBase line : program) {
            AggregateLiteral aggLit;
            List<Literal> tmpList;
            if (!GringoRule.class.isAssignableFrom(line.getClass())) continue;
            GringoRule rule = (GringoRule)line;
            if (rule.getHead() != null && (this.mrRuleTarget == RuleTargetEnum.ALL || this.mrRuleTarget == RuleTargetEnum.HEAD)) {
                for (Literal lit : rule.getHead()) {
                    if (lit.isModified()) continue;
                    tmpList = Literal.findClassesByType(AggregateLiteral.class, lit);
                    for (Literal mt : tmpList) {
                        aggLit = (AggregateLiteral)mt;
                        if (aggLit.isModified() || aggLit.getLower() == null && aggLit.getUpper() == null) continue;
                        result.add(mt);
                    }
                }
            }
            if (rule.getBody() == null || this.mrRuleTarget != RuleTargetEnum.ALL && this.mrRuleTarget != RuleTargetEnum.BODY) continue;
            for (Literal lit : rule.getBody()) {
                if (lit.isModified()) continue;
                tmpList = Literal.findClassesByType(AggregateLiteral.class, lit);
                for (Literal mt : tmpList) {
                    aggLit = (AggregateLiteral)mt;
                    if (aggLit.isModified() || aggLit.getLower() == null && aggLit.getUpper() == null) continue;
                    result.add(mt);
                }
            }
        }
        return result;
    }

    @Override
    public ModificationRuleTypeEnum getRuleTypeEnum() {
        return ModificationRuleTypeEnum.ATA;
    }

    @Override
    protected void modifyLiteral(Literal lit) {
        AggregateLiteral aggregateLiteral = (AggregateLiteral)lit;
        Term lowerConstant = aggregateLiteral.getLower();
        Term upperConstant = aggregateLiteral.getUpper();
        boolean modifyLower = this.random.nextBoolean();
        boolean shouldIncrement = this.random.nextBoolean();
        if (lowerConstant == null) {
            modifyLower = false;
        }
        if (upperConstant == null) {
            modifyLower = true;
        }
        if ((lowerConstant == null || ConstTerm.class.isAssignableFrom(lowerConstant.getClass())) && (upperConstant == null || ConstTerm.class.isAssignableFrom(upperConstant.getClass()))) {
            this.bothInteger(lowerConstant, upperConstant, modifyLower, shouldIncrement);
        } else {
            if (ConstTerm.class.isAssignableFrom(lowerConstant.getClass()) && ConstTerm.class.isAssignableFrom(upperConstant.getClass()) && lowerConstant.toString().equals(upperConstant.toString())) {
                if (shouldIncrement && modifyLower) {
                    shouldIncrement = false;
                }
                if (!shouldIncrement && !modifyLower) {
                    shouldIncrement = true;
                }
            }
            if (modifyLower) {
                Term newLiteral = this.toRename(lit, aggregateLiteral, lowerConstant, shouldIncrement, "lower");
                aggregateLiteral.setLower(newLiteral);
            } else {
                Term newLiteral = this.toRename(lit, aggregateLiteral, upperConstant, shouldIncrement, "upper");
                aggregateLiteral.setUpper(newLiteral);
            }
        }
    }

    private Term toRename(Literal lit, AggregateLiteral aggregateLiteral, Term target, boolean shouldIncrement, String targetName) {
        Term returnValue = target;
        if (ConstTerm.class.isAssignableFrom(target.getClass())) {
            int value = Integer.parseInt(target.getIdentifier());
            if (shouldIncrement || value <= 1) {
                target.setIdentifier(Integer.toString(value + 1));
                if (this.writeComments) {
                    target.addSucceedingComment("%* ModificationNote: " + targetName + " value has been incremented. Original value was " + value + "  *%");
                }
            } else {
                target.setIdentifier(Integer.toString(value - 1));
                if (this.writeComments) {
                    target.addSucceedingComment("%* ModificationNote: " + targetName + " value has been decremented. Original value was " + value + "  *%");
                }
            }
        } else if (shouldIncrement) {
            returnValue = new MathTerm("+", target, new ConstTerm(1, lit.getLineNo()), lit.getLineNo());
            if (this.writeComments) {
                returnValue.addSucceedingComment("%* ModificationNote: " + targetName + " value has been incremented. Original value was " + target.toString() + "  *%");
            }
        } else {
            returnValue = new MathTerm("-", target, new ConstTerm(1, lit.getLineNo()), lit.getLineNo());
            if (this.writeComments) {
                returnValue.addSucceedingComment("%* ModificationNote: " + targetName + " value has been decremented. Original value was " + target.toString() + "  *%");
            }
        }
        return returnValue;
    }
}

