/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.modificationrules.gringo;

import aspmodificator.model.LineBase;
import aspmodificator.modificationrules.gringo.AbstractReplacementLiteralModificationRule;
import aspmodificator.modificationrules.gringo.ModificationRuleTypeEnum;
import aspmodificator.modificationrules.gringo.RuleTargetEnum;
import aspmodificator.parser.gringo.GringoRule;
import aspmodificator.parser.gringo.Literal;
import aspmodificator.parser.gringo.Term;
import aspmodificator.parser.gringo.VarTerm;
import common.Pair;
import common.Tripple;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;

public class ConstantToVariableModificationRule
extends AbstractReplacementLiteralModificationRule<String> {
    protected static final String COMMENT_CONSTANT_TO_VARIABLE = "%*ModificationNote: term has been modified from a constant to a variable*%";

    public ConstantToVariableModificationRule() {
    }

    public ConstantToVariableModificationRule(int minApplication, int maxApplication) {
        super(minApplication, maxApplication);
    }

    private boolean checkPreconditions(Literal lit) {
        Term term = (Term)lit;
        if (term.getTerms() != null && term.getTerms().size() > 0) {
            return false;
        }
        return Pattern.matches("[a-z].*", term.getIdentifier());
    }

    @Override
    protected List<Tripple<Literal, Literal, List<String>>> findApplicableObjects(List<LineBase> program) {
        ArrayList<Tripple<Literal, Literal, List<String>>> result = new ArrayList<Tripple<Literal, Literal, List<String>>>();
        for (LineBase line : program) {
            List<Pair<Literal, Literal>> termList;
            List<VarTerm> tmp;
            if (!GringoRule.class.isAssignableFrom(line.getClass())) continue;
            GringoRule rule = (GringoRule)line;
            HashSet<String> variables = new HashSet<String>();
            if (rule.getHead() != null && !rule.getHead().isEmpty()) {
                for (Literal lit : rule.getHead()) {
                    tmp = lit.getVariables();
                    if (tmp == null || tmp.size() <= 0) continue;
                    for (Literal literal : tmp) {
                        variables.add(literal.getIdentifier());
                    }
                }
            }
            if (rule.getBody() != null && !rule.getBody().isEmpty()) {
                for (Literal lit : rule.getBody()) {
                    tmp = lit.getVariables();
                    if (tmp == null || tmp.size() <= 0) continue;
                    for (Literal literal : tmp) {
                        variables.add(literal.getIdentifier());
                    }
                }
            }
            ArrayList variableNames = new ArrayList(variables);
            if (rule.getHead() != null && (this.mrRuleTarget == RuleTargetEnum.ALL || this.mrRuleTarget == RuleTargetEnum.HEAD)) {
                termList = Literal.findClassesByTypeWithParent(Term.class, rule.getHead(), null);
                for (Pair pair : termList) {
                    if (!this.checkPreconditions((Literal)pair.getFirst()) || ((Literal)pair.getFirst()).isModified()) continue;
                    result.add(new Tripple((Literal)pair.getFirst(), (Literal)pair.getSecond(), variableNames));
                }
            }
            if (rule.getBody() == null || this.mrRuleTarget != RuleTargetEnum.ALL && this.mrRuleTarget != RuleTargetEnum.BODY) continue;
            termList = Literal.findClassesByTypeWithParent(Term.class, rule.getBody(), null);
            for (Pair pair : termList) {
                if (!this.checkPreconditions((Literal)pair.getFirst()) || ((Literal)pair.getFirst()).isModified()) continue;
                result.add(new Tripple((Literal)pair.getFirst(), (Literal)pair.getSecond(), variableNames));
            }
        }
        return result;
    }

    @Override
    public ModificationRuleTypeEnum getRuleTypeEnum() {
        return ModificationRuleTypeEnum.TCV;
    }

    protected Literal modifyLiteral(Pair<Literal, Literal> pair) {
        String name = String.valueOf(pair.getFirst().getIdentifier().substring(0, 1).toUpperCase()) + pair.getFirst().getIdentifier().substring(1);
        VarTerm newLit = new VarTerm(name, pair.getFirst().getLineNo());
        if (this.writeComments) {
            newLit.addSucceedingComment(COMMENT_CONSTANT_TO_VARIABLE);
        }
        return newLit;
    }

    @Override
    protected Literal modifyLiteral(Tripple<Literal, Literal, List<String>> tripple, int index) {
        VarTerm newLit = new VarTerm(tripple.getThird().get(index), tripple.getFirst().getLineNo());
        if (this.writeComments) {
            newLit.addSucceedingComment(COMMENT_CONSTANT_TO_VARIABLE);
        }
        return newLit;
    }
}

