/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.modificationrules.gringo;

import aspmodificator.model.CommentLine;
import aspmodificator.model.LineBase;
import aspmodificator.modificationrules.gringo.AbstractModificationRule;
import aspmodificator.modificationrules.gringo.LogicRuleTypeEnum;
import aspmodificator.modificationrules.gringo.ModificationRuleTypeEnum;
import aspmodificator.parser.gringo.GringoRule;
import java.util.ArrayList;
import java.util.List;

public class DeleteRuleModificationRule
extends AbstractModificationRule {
    private LogicRuleTypeEnum ruleType = LogicRuleTypeEnum.ALL;

    public DeleteRuleModificationRule() {
    }

    public DeleteRuleModificationRule(int min, int max) {
        super(min, max);
    }

    @Override
    public int apply(List<LineBase> program) {
        List<GringoRule> applicableRules = this.findApplicableRules(program);
        if (applicableRules.size() == 0) {
            return 0;
        }
        int ruleApplied = 0;
        double chance = (double)(this.minApplication + this.maxApplication) / (double)(2 * applicableRules.size());
        int noApplicapleObject = 0;
        block0: do {
            noApplicapleObject = applicableRules.size();
            int objectIndex = -1;
            for (GringoRule rule : applicableRules) {
                ++objectIndex;
                if (rule.isModified()) {
                    --noApplicapleObject;
                    continue;
                }
                if (this.useMemory && this.tabuList.isTabu(ModificationRuleTypeEnum.RDP, 1, objectIndex)) {
                    --noApplicapleObject;
                    continue;
                }
                double randomValue = this.random.nextDouble();
                if (!(randomValue <= chance)) continue;
                int index = program.indexOf(rule);
                program.remove(index);
                if (this.writeComments) {
                    program.add(index, new CommentLine("%* ModificationNote: The following rule has been removed: " + rule.toOutputString() + " *%", rule.getStartLineNo()));
                }
                rule.setModified(true);
                ++ruleApplied;
                --noApplicapleObject;
                if (this.useMemory) {
                    this.tabuList.setTabu(ModificationRuleTypeEnum.RDP, 1, objectIndex);
                }
                if (ruleApplied == this.maxApplication) continue block0;
            }
        } while (noApplicapleObject > 0 && ruleApplied < this.maxApplication && ruleApplied < this.minApplication);
        return ruleApplied;
    }

    private List<GringoRule> findApplicableRules(List<LineBase> program) {
        ArrayList<GringoRule> result = new ArrayList<GringoRule>();
        block5: for (LineBase line : program) {
            if (!GringoRule.class.isAssignableFrom(line.getClass())) continue;
            GringoRule rule = (GringoRule)line;
            switch (this.ruleType) {
                case FACT: {
                    if (rule.getHead() == null || rule.getHead().isEmpty() || rule.getBody() != null && !rule.getBody().isEmpty()) continue block5;
                    result.add(rule);
                    break;
                }
                case CONSTRAINT: {
                    if (rule.getHead() != null && !rule.getHead().isEmpty() || rule.getBody() == null || rule.getBody().isEmpty()) continue block5;
                    result.add(rule);
                    break;
                }
                case PROPER: {
                    if (rule.getHead() == null || rule.getHead().isEmpty() || rule.getBody() == null || rule.getBody().isEmpty()) continue block5;
                    result.add(rule);
                    break;
                }
                default: {
                    result.add(rule);
                }
            }
        }
        return result;
    }

    public LogicRuleTypeEnum getRuleType() {
        return this.ruleType;
    }

    @Override
    public ModificationRuleTypeEnum getRuleTypeEnum() {
        return ModificationRuleTypeEnum.RDP;
    }

    public void setRuleType(LogicRuleTypeEnum ruleType) {
        this.ruleType = ruleType;
    }
}

