/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.modificationrules.gringo;

import aspmodificator.model.LineBase;
import aspmodificator.modificationrules.gringo.AbstractModificationRule;
import aspmodificator.modificationrules.gringo.GringoRuleUtil;
import aspmodificator.modificationrules.gringo.ModificationRuleTypeEnum;
import aspmodificator.modificationrules.gringo.RuleTargetEnum;
import aspmodificator.parser.gringo.AggregateLiteral;
import aspmodificator.parser.gringo.GringoRule;
import aspmodificator.parser.gringo.ICommentable;
import aspmodificator.parser.gringo.Literal;
import aspmodificator.parser.gringo.PoolTerm;
import common.Tripple;
import java.util.ArrayList;
import java.util.List;

public class DeleteTermModificationRule
extends AbstractModificationRule {
    protected boolean includeInsideLiterals = true;

    public DeleteTermModificationRule() {
    }

    public DeleteTermModificationRule(int minApplication, int maxApplication) {
        super(minApplication, maxApplication);
    }

    private void addInsideLiterals(List<Tripple<Literal, List<Literal>, ICommentable>> result, GringoRule rule, Literal lit) {
        if (this.containsRemovableLiterals(lit) && lit.getTerms() != null && lit.getTerms().size() > 1) {
            int j = 0;
            while (j < lit.getTerms().size()) {
                Literal lit2 = lit.getTerms().remove(j);
                boolean safe = GringoRuleUtil.checkSafety(rule);
                if (safe) {
                    ICommentable commentable = null;
                    commentable = j < lit.getTerms().size() ? (ICommentable)lit.getTerms().get(j) : (ICommentable)lit.getTerms().get(j - 1);
                    result.add(new Tripple<Literal, List<Literal>, ICommentable>(lit2, lit.getTerms(), commentable));
                }
                lit.getTerms().add(j, lit2);
                ++j;
            }
        }
    }

    @Override
    public int apply(List<LineBase> program) {
        List<Tripple<Literal, List<Literal>, ICommentable>> applicableObjectPairs = this.findApplicableObjects(program);
        if (applicableObjectPairs.size() == 0) {
            return 0;
        }
        int ruleApplied = 0;
        double chance = (double)(this.minApplication + this.maxApplication) / (double)(2 * applicableObjectPairs.size());
        int noApplicableObjects = applicableObjectPairs.size();
        block0: while (noApplicableObjects > 0 && ruleApplied < this.maxApplication && ruleApplied < this.minApplication) {
            noApplicableObjects = applicableObjectPairs.size();
            int objectIndex = -1;
            for (Tripple<Literal, List<Literal>, ICommentable> tripple : applicableObjectPairs) {
                ++objectIndex;
                if (tripple.getFirst().isModified()) {
                    --noApplicableObjects;
                    continue;
                }
                if (this.useMemory && this.tabuList.isTabu(this.getRuleTypeEnum(), tripple.getFirst().getLineNo(), objectIndex)) {
                    --noApplicableObjects;
                    continue;
                }
                double randomValue = this.random.nextDouble();
                if (!(randomValue <= chance)) continue;
                Literal newLiteral = this.modifyLiteral(tripple);
                int index = tripple.getSecond().indexOf(tripple.getFirst());
                if (index >= 0) {
                    tripple.getSecond().remove(index);
                }
                if (newLiteral != null) {
                    tripple.getSecond().add(index, newLiteral);
                    newLiteral.setModified(true);
                }
                ++ruleApplied;
                --noApplicableObjects;
                if (this.useMemory) {
                    this.tabuList.setTabu(this.getRuleTypeEnum(), tripple.getFirst().getLineNo(), objectIndex);
                }
                if (ruleApplied == this.maxApplication) continue block0;
            }
        }
        return ruleApplied;
    }

    private boolean containsRemovableLiterals(Literal lit) {
        if (AggregateLiteral.class.isAssignableFrom(lit.getClass())) {
            return true;
        }
        return PoolTerm.class.isAssignableFrom(lit.getClass());
    }

    protected List<Tripple<Literal, List<Literal>, ICommentable>> findApplicableObjects(List<LineBase> program) {
        ArrayList<Tripple<Literal, List<Literal>, ICommentable>> result = new ArrayList<Tripple<Literal, List<Literal>, ICommentable>>();
        for (LineBase line : program) {
            ICommentable commentable;
            boolean safe;
            Literal lit;
            int i;
            if (!GringoRule.class.isAssignableFrom(line.getClass())) continue;
            GringoRule rule = (GringoRule)line;
            if (rule.getHead() != null && rule.getHead().size() > 0 && (this.mrRuleTarget == RuleTargetEnum.ALL || this.mrRuleTarget == RuleTargetEnum.HEAD)) {
                int headSize = rule.getHead().size();
                i = 0;
                while (i < headSize) {
                    if (rule.getBody() != null && !rule.getBody().isEmpty()) {
                        lit = rule.getHead().remove(i);
                        safe = GringoRuleUtil.checkSafety(rule);
                        if (safe) {
                            commentable = null;
                            commentable = i == headSize - 1 ? rule.getCenterCommentable() : (i < rule.getHead().size() - 1 ? (ICommentable)rule.getHead().get(i + 1) : rule.getCenterCommentable());
                            result.add(new Tripple<Literal, List<Literal>, ICommentable>(lit, rule.getHead(), commentable));
                        }
                        rule.getHead().add(i, lit);
                    }
                    if (this.includeInsideLiterals) {
                        this.addInsideLiterals(result, rule, rule.getHead().get(i));
                    }
                    ++i;
                }
            }
            if (rule.getBody() == null || this.mrRuleTarget != RuleTargetEnum.BODY && this.mrRuleTarget != RuleTargetEnum.ALL) continue;
            int bodySize = rule.getBody().size();
            i = 0;
            while (i < bodySize) {
                if (rule.getBody().size() > 1 || rule.getHead() != null && !rule.getHead().isEmpty()) {
                    lit = rule.getBody().remove(i);
                    safe = GringoRuleUtil.checkSafety(rule);
                    if (safe) {
                        commentable = null;
                        commentable = i == bodySize - 1 ? rule.getBackCommentable() : (i < rule.getBody().size() ? (ICommentable)rule.getBody().get(i) : rule.getBackCommentable());
                        result.add(new Tripple<Literal, List<Literal>, ICommentable>(lit, rule.getBody(), commentable));
                    }
                    rule.getBody().add(i, lit);
                }
                if (this.includeInsideLiterals) {
                    this.addInsideLiterals(result, rule, rule.getBody().get(i));
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public ModificationRuleTypeEnum getRuleTypeEnum() {
        switch (this.mrRuleTarget) {
            case HEAD: {
                return ModificationRuleTypeEnum.LDH;
            }
            case BODY: {
                return ModificationRuleTypeEnum.LDB;
            }
        }
        return ModificationRuleTypeEnum.LDA;
    }

    public boolean isIncludeInsideLiterals() {
        return this.includeInsideLiterals;
    }

    protected Literal modifyLiteral(Tripple<Literal, List<Literal>, ICommentable> tripple) {
        ICommentable commentable;
        if (this.writeComments && (commentable = tripple.getThird()) != null) {
            commentable.addPrecedingComment("%*ModificationNote: Literal " + tripple.getFirst().toString() + " has been removed*%");
        }
        return null;
    }

    public void setIncludeInsideLiterals(boolean includeInsideLiterals) {
        this.includeInsideLiterals = includeInsideLiterals;
    }
}

