/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.modificationrules.gringo;

import aspmodificator.parser.gringo.GringoRule;
import aspmodificator.parser.gringo.Literal;
import aspmodificator.parser.gringo.MathTerm;
import aspmodificator.parser.gringo.Predicate;
import aspmodificator.parser.gringo.RelLit;
import aspmodificator.parser.gringo.VarTerm;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class GringoRuleUtil {
    public static boolean checkSafety(GringoRule rule) {
        Set<String> headVariables = GringoRuleUtil.getVariables(rule.getHead());
        Set<String> negBodyVariables = GringoRuleUtil.getNegBodyVariables(rule.getBody());
        Set<String> otherNotSafeVariables = GringoRuleUtil.getOtherNotSafeVariables(rule.getBody());
        HashSet<String> varSet = new HashSet<String>();
        varSet.addAll(headVariables);
        varSet.addAll(negBodyVariables);
        varSet.addAll(otherNotSafeVariables);
        if (varSet.size() == 0) {
            return true;
        }
        if (rule.getBody() != null) {
            Iterator<Literal> it = rule.getBody().iterator();
            while (it.hasNext() && !varSet.isEmpty()) {
                Literal lit = it.next();
                GringoRuleUtil.removeBoundedVariables(varSet, lit);
            }
            if (varSet.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    private static Set<String> getNegBodyVariables(List<Literal> termList) {
        HashSet<String> result = new HashSet<String>();
        if (termList == null || termList.size() == 0) {
            return result;
        }
        for (Literal lit : termList) {
            List<VarTerm> vars;
            if (!lit.isSigned() || (vars = lit.getVariables()) == null || vars.size() <= 0) continue;
            for (VarTerm var : vars) {
                result.add(var.getIdentifier());
            }
        }
        return result;
    }

    private static Set<String> getOtherNotSafeVariables(List<Literal> termList) {
        HashSet<String> result = new HashSet<String>();
        if (termList == null || termList.size() == 0) {
            return result;
        }
        for (Literal lit : termList) {
            List<VarTerm> vars;
            List<Literal> literalList = Literal.findClassesByType(MathTerm.class, lit);
            for (Literal lit2 : literalList) {
                vars = lit2.getVariables();
                if (vars == null || vars.size() <= 0) continue;
                for (VarTerm var : vars) {
                    result.add(var.getIdentifier());
                }
            }
            literalList = Literal.findClassesByType(RelLit.class, lit);
            for (Literal lit2 : literalList) {
                vars = lit2.getVariables();
                if (vars == null || vars.size() <= 0) continue;
                for (VarTerm var : vars) {
                    result.add(var.getIdentifier());
                }
            }
        }
        return result;
    }

    private static Set<String> getVariables(List<Literal> termList) {
        HashSet<String> result = new HashSet<String>();
        if (termList == null || termList.size() == 0) {
            return result;
        }
        for (Literal lit : termList) {
            List<VarTerm> vars = lit.getVariables();
            if (vars == null || vars.size() <= 0) continue;
            for (VarTerm var : vars) {
                result.add(var.getIdentifier());
            }
        }
        return result;
    }

    private static void removeBoundedVariables(Set<String> varSet, Literal lit) {
        if (lit.isSigned()) {
            return;
        }
        if (RelLit.class.equals(lit.getClass()) && (lit.getIdentifier().equals("=") || lit.getIdentifier().equals(":="))) {
            List<VarTerm> varList;
            if (lit.getTerms() != null && lit.getTerms().size() > 0 && (varList = lit.getTerms().get(0).getVariables()) != null && varList.size() == 1) {
                VarTerm saveVarCandidate = varList.get(0);
                List<VarTerm> rightSideVarList = lit.getTerms().get(1).getVariables();
                if (rightSideVarList != null && rightSideVarList.size() > 0) {
                    for (VarTerm var : rightSideVarList) {
                        if (!var.getIdentifier().equals(saveVarCandidate.getIdentifier())) continue;
                        return;
                    }
                }
                varSet.remove(saveVarCandidate.getIdentifier());
            }
            return;
        }
        if (!Predicate.class.isAssignableFrom(lit.getClass())) {
            return;
        }
        List<VarTerm> vars = lit.getVariables();
        if (vars != null && vars.size() > 0) {
            for (VarTerm var : vars) {
                varSet.remove(var.getIdentifier());
            }
        }
    }
}

