/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.modificationrules.gringo;

import aspmodificator.model.LineBase;
import aspmodificator.modificationrules.gringo.AbstractModificationRule;
import aspmodificator.modificationrules.gringo.ModificationRuleTypeEnum;
import aspmodificator.modificationrules.gringo.RuleTargetEnum;
import aspmodificator.parser.gringo.GringoRule;
import aspmodificator.parser.gringo.Literal;
import aspmodificator.parser.gringo.MathTerm;
import java.util.ArrayList;
import java.util.List;

public class MathOperatorsModificationRule
extends AbstractModificationRule {
    public static final String[] dualOperators = new String[]{"/", "\\", "+", "-", "**", "*"};
    public static final String[] singleOperators = new String[]{"&", "^", "~"};

    public MathOperatorsModificationRule() {
    }

    public MathOperatorsModificationRule(int minApplication, int maxApplication) {
        super(minApplication, maxApplication);
    }

    @Override
    public int apply(List<LineBase> program) {
        List<Literal> applicableObject = this.findApplicableObjects(program);
        if (applicableObject.size() == 0) {
            return 0;
        }
        int ruleApplied = 0;
        double chance = (double)(this.minApplication + this.maxApplication) / (double)(2 * applicableObject.size());
        int applicableObjectNo = applicableObject.size();
        block0: while (applicableObjectNo > 0 && ruleApplied < this.maxApplication && ruleApplied < this.minApplication) {
            applicableObjectNo = applicableObject.size();
            int objectIndex = -1;
            for (Literal lit : applicableObject) {
                int maxTries;
                int tries;
                ++objectIndex;
                if (lit.isModified()) {
                    --applicableObjectNo;
                    continue;
                }
                double randomValue = this.random.nextDouble();
                if (!(randomValue <= chance)) continue;
                int index = -1;
                if (lit.getTerms().size() == 1) {
                    index = this.random.nextInt(singleOperators.length);
                    tries = 0;
                    maxTries = (singleOperators.length - 1) * 2;
                    while (singleOperators[index].equals(lit.getIdentifier()) || this.useMemory && this.tabuList.isTabu(this.getRuleTypeEnum(), lit.getLineNo(), objectIndex, index) && tries < maxTries) {
                        index = this.random.nextInt(singleOperators.length);
                        ++tries;
                    }
                    if (this.useMemory && tries >= maxTries) {
                        --applicableObjectNo;
                        continue;
                    }
                    this.modifyLiteral(lit, singleOperators[index]);
                } else {
                    tries = 0;
                    maxTries = (dualOperators.length - 1) * 2;
                    index = this.random.nextInt(dualOperators.length);
                    while (dualOperators[index].equals(lit.getIdentifier()) || this.useMemory && this.tabuList.isTabu(this.getRuleTypeEnum(), lit.getLineNo(), objectIndex, index) && tries < maxTries) {
                        index = this.random.nextInt(dualOperators.length);
                        ++tries;
                    }
                    if (this.useMemory && tries >= maxTries) {
                        --applicableObjectNo;
                        continue;
                    }
                    this.modifyLiteral(lit, dualOperators[index]);
                }
                lit.setModified(true);
                ++ruleApplied;
                --applicableObjectNo;
                if (this.useMemory) {
                    this.tabuList.setTabu(this.getRuleTypeEnum(), lit.getLineNo(), objectIndex, index);
                }
                if (ruleApplied == this.maxApplication) continue block0;
            }
        }
        return ruleApplied;
    }

    protected List<Literal> findApplicableObjects(List<LineBase> program) {
        ArrayList<Literal> result = new ArrayList<Literal>();
        for (LineBase line : program) {
            List<Literal> tmpList;
            if (!GringoRule.class.isAssignableFrom(line.getClass())) continue;
            GringoRule rule = (GringoRule)line;
            if (rule.getHead() != null && (this.mrRuleTarget == RuleTargetEnum.ALL || this.mrRuleTarget == RuleTargetEnum.HEAD)) {
                for (Literal lit : rule.getHead()) {
                    if (lit.isModified()) continue;
                    tmpList = Literal.findClassesByType(MathTerm.class, lit);
                    for (Literal mt : tmpList) {
                        if (mt.isModified() || mt.getTerms() == null || mt.getTerms().size() == 0 || mt.getTerms().size() > 2) continue;
                        result.add(mt);
                    }
                }
            }
            if (rule.getBody() == null || this.mrRuleTarget != RuleTargetEnum.ALL && this.mrRuleTarget != RuleTargetEnum.BODY) continue;
            for (Literal lit : rule.getBody()) {
                if (lit.isModified()) continue;
                tmpList = Literal.findClassesByType(MathTerm.class, lit);
                for (Literal mt : tmpList) {
                    if (mt.isModified()) continue;
                    result.add(mt);
                }
            }
        }
        return result;
    }

    @Override
    public ModificationRuleTypeEnum getRuleTypeEnum() {
        return ModificationRuleTypeEnum.ARO;
    }

    protected void modifyLiteral(Literal lit, String newIdentifier) {
        if (this.writeComments) {
            lit.addSucceedingComment("%* ModificationNote: operator has been modified. Original operator was \"" + lit.getIdentifier() + "\" *%");
        }
        lit.setIdentifier(newIdentifier);
    }
}

