/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.modificationrules.gringo;

import aspmodificator.model.LineBase;
import aspmodificator.modificationrules.gringo.AbstractLiteralModificationRule;
import aspmodificator.modificationrules.gringo.ModificationRuleTypeEnum;
import aspmodificator.modificationrules.gringo.RuleTargetEnum;
import aspmodificator.parser.gringo.ConstTerm;
import aspmodificator.parser.gringo.GringoRule;
import aspmodificator.parser.gringo.Literal;
import aspmodificator.parser.gringo.MathTerm;
import aspmodificator.parser.gringo.RangeTerm;
import aspmodificator.parser.gringo.Term;
import java.util.ArrayList;
import java.util.List;

public class RangeTermModificationRule
extends AbstractLiteralModificationRule {
    public RangeTermModificationRule() {
    }

    public RangeTermModificationRule(int minApplication, int maxApplication) {
        super(minApplication, maxApplication);
    }

    @Override
    protected List<Literal> findApplicableObjects(List<LineBase> program) {
        ArrayList<Literal> result = new ArrayList<Literal>();
        for (LineBase line : program) {
            List<Literal> tmpList;
            if (!GringoRule.class.isAssignableFrom(line.getClass())) continue;
            GringoRule rule = (GringoRule)line;
            if (rule.getHead() != null && (this.mrRuleTarget == RuleTargetEnum.ALL || this.mrRuleTarget == RuleTargetEnum.HEAD)) {
                for (Literal lit : rule.getHead()) {
                    if (lit.isModified()) continue;
                    tmpList = Literal.findClassesByType(RangeTerm.class, lit);
                    for (Literal mt : tmpList) {
                        if (mt.isModified()) continue;
                        result.add(mt);
                    }
                }
            }
            if (rule.getBody() == null || this.mrRuleTarget != RuleTargetEnum.ALL && this.mrRuleTarget != RuleTargetEnum.BODY) continue;
            for (Literal lit : rule.getBody()) {
                if (lit.isModified()) continue;
                tmpList = Literal.findClassesByType(RangeTerm.class, lit);
                for (Literal mt : tmpList) {
                    if (mt.isModified()) continue;
                    result.add(mt);
                }
            }
        }
        return result;
    }

    @Override
    public ModificationRuleTypeEnum getRuleTypeEnum() {
        return ModificationRuleTypeEnum.TODO;
    }

    @Override
    protected void modifyLiteral(Literal lit) {
        boolean modifyLower = this.random.nextBoolean();
        boolean shouldIncrement = this.random.nextBoolean();
        RangeTerm rangeTerm = (RangeTerm)lit;
        Integer lower = null;
        Integer upper = null;
        if (ConstTerm.class.isAssignableFrom(rangeTerm.getLowerRange().getClass())) {
            lower = Integer.valueOf(rangeTerm.getLowerRange().getIdentifier());
        }
        if (ConstTerm.class.isAssignableFrom(rangeTerm.getUpperRange().getClass())) {
            upper = Integer.valueOf(rangeTerm.getUpperRange().getIdentifier());
        }
        boolean onlyOneDifferent = false;
        if (lower != null && upper != null && lower + 1 == upper) {
            onlyOneDifferent = true;
        }
        if (modifyLower) {
            Term lowerRange = rangeTerm.getLowerRange();
            if (lower != null) {
                if (onlyOneDifferent || !shouldIncrement) {
                    lowerRange.setIdentifier(Integer.toString(lower - 1));
                    if (this.writeComments) {
                        lowerRange.addSucceedingComment("%* ModificationNote: lower value has been decreased. Original value was " + lower + "  *%");
                    }
                } else {
                    lowerRange.setIdentifier(Integer.toString(lower + 1));
                    if (this.writeComments) {
                        lowerRange.addSucceedingComment("%* ModificationNote: lower value has been increased. Original value was " + lower + "  *%");
                    }
                }
            } else if (onlyOneDifferent || !shouldIncrement) {
                MathTerm mathTerm = new MathTerm("-", lowerRange, new ConstTerm(1, lowerRange.getLineNo()), lowerRange.getLineNo());
                rangeTerm.setLowerRange(mathTerm);
                if (this.writeComments) {
                    rangeTerm.addSucceedingComment("%* ModificationNote: lower value has been decreased. Original value was " + lower + "  *%");
                }
            } else {
                MathTerm mathTerm = new MathTerm("+", lowerRange, new ConstTerm(1, lowerRange.getLineNo()), lowerRange.getLineNo());
                rangeTerm.setLowerRange(mathTerm);
                if (this.writeComments) {
                    rangeTerm.addSucceedingComment("%* ModificationNote: lower value has been increased. Original value was " + lower + "  *%");
                }
            }
        } else {
            Term upperRange = rangeTerm.getUpperRange();
            if (upper != null) {
                if (onlyOneDifferent || shouldIncrement) {
                    upperRange.setIdentifier(Integer.toString(upper + 1));
                    if (this.writeComments) {
                        upperRange.addSucceedingComment("%* ModificationNote: upper value has been increased. Original value was " + upper + "  *%");
                    }
                } else {
                    upperRange.setIdentifier(Integer.toString(upper - 1));
                    if (this.writeComments) {
                        upperRange.addSucceedingComment("%* ModificationNote: upper value has been decreased. Original value was " + upper + "  *%");
                    }
                }
            } else if (onlyOneDifferent || shouldIncrement) {
                MathTerm mathTerm = new MathTerm("+", upperRange, new ConstTerm(1, upperRange.getLineNo()), upperRange.getLineNo());
                rangeTerm.setUpperRange(mathTerm);
                if (this.writeComments) {
                    rangeTerm.addSucceedingComment("%* ModificationNote: upper value has been increased. Original value was " + upper + "  *%");
                }
            } else {
                MathTerm mathTerm = new MathTerm("-", upperRange, new ConstTerm(1, upperRange.getLineNo()), upperRange.getLineNo());
                rangeTerm.setUpperRange(mathTerm);
                if (this.writeComments) {
                    rangeTerm.addSucceedingComment("%* ModificationNote: lower value has been decreased. Original value was " + upper + "  *%");
                }
            }
        }
    }
}

