/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.modificationrules.gringo;

import aspmodificator.model.LineBase;
import aspmodificator.modificationrules.gringo.SwitchDefaultNegationModificationRule;
import aspmodificator.parser.gringo.GringoRule;
import aspmodificator.parser.gringo.Literal;
import java.util.ArrayList;
import java.util.List;

public class RemoveDefaultNegationModificationRule
extends SwitchDefaultNegationModificationRule {
    public RemoveDefaultNegationModificationRule() {
    }

    public RemoveDefaultNegationModificationRule(int minApplication, int maxApplication) {
        super(minApplication, maxApplication);
    }

    @Override
    protected List<Literal> findApplicableObjects(List<LineBase> program) {
        ArrayList<Literal> result = new ArrayList<Literal>();
        for (LineBase line : program) {
            GringoRule rule;
            if (!GringoRule.class.isAssignableFrom(line.getClass()) || (rule = (GringoRule)line).getBody() == null) continue;
            for (Literal lit : rule.getBody()) {
                if (!this.allowsDefaultNegation(lit.getClass()) || lit.isModified() || !lit.isSigned()) continue;
                result.add(lit);
            }
        }
        return result;
    }

    @Override
    protected void modifyLiteral(Literal lit) {
        lit.setSigned(false);
        if (this.writeComments) {
            lit.addSucceedingComment("%*ModificationNote: removed default-negation \"not\" *%");
        }
    }
}

