/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.modificationrules.gringo;

import aspmodificator.model.LineBase;
import aspmodificator.modificationrules.gringo.RuleTargetEnum;
import aspmodificator.modificationrules.gringo.SwapStrongNegationModificationRule;
import aspmodificator.parser.gringo.GringoRule;
import aspmodificator.parser.gringo.Literal;
import aspmodificator.parser.gringo.Predicate;
import java.util.ArrayList;
import java.util.List;

public class RemoveStrongNegationModificationRule
extends SwapStrongNegationModificationRule {
    public RemoveStrongNegationModificationRule() {
    }

    public RemoveStrongNegationModificationRule(int minApplication, int maxApplication) {
        super(minApplication, maxApplication);
    }

    public RemoveStrongNegationModificationRule(int minApplication, int maxApplication, boolean requireExistingPredicate) {
        super(minApplication, maxApplication, requireExistingPredicate);
    }

    @Override
    protected List<Literal> findApplicableObjects(List<LineBase> program) {
        ArrayList<Literal> result = new ArrayList<Literal>();
        ArrayList<Literal> unNegatedLiterals = new ArrayList<Literal>();
        for (LineBase line : program) {
            Predicate pred;
            if (!GringoRule.class.isAssignableFrom(line.getClass())) continue;
            GringoRule rule = (GringoRule)line;
            if (rule.getHead() != null) {
                for (Literal lit : rule.getHead()) {
                    if (!Predicate.class.isAssignableFrom(lit.getClass()) || lit.isModified()) continue;
                    pred = (Predicate)lit;
                    if (pred.isNegated()) {
                        if (this.mrRuleTarget != RuleTargetEnum.ALL && this.mrRuleTarget != RuleTargetEnum.HEAD) continue;
                        result.add(lit);
                        continue;
                    }
                    if (!this.requireExistingObject) continue;
                    unNegatedLiterals.add(lit);
                }
            }
            if (rule.getBody() == null) continue;
            for (Literal lit : rule.getBody()) {
                if (!Predicate.class.isAssignableFrom(lit.getClass()) || lit.isModified()) continue;
                pred = (Predicate)lit;
                if (pred.isNegated()) {
                    if (this.mrRuleTarget != RuleTargetEnum.ALL && this.mrRuleTarget != RuleTargetEnum.BODY) continue;
                    result.add(lit);
                    continue;
                }
                if (!this.requireExistingObject) continue;
                unNegatedLiterals.add(lit);
            }
        }
        if (this.requireExistingObject) {
            ArrayList<Literal> toRemove = new ArrayList<Literal>();
            for (Literal lit : result) {
                boolean found = false;
                for (Literal unNegLit : unNegatedLiterals) {
                    if (!unNegLit.getIdentifier().equals(lit.getIdentifier()) || unNegLit.getArity() != lit.getArity()) continue;
                    found = true;
                }
                if (found) continue;
                toRemove.add(lit);
            }
            result.removeAll(toRemove);
        }
        return result;
    }

    @Override
    protected void modifyLiteral(Literal lit) {
        Predicate pred = (Predicate)lit;
        pred.setNegated(false);
        if (this.writeComments) {
            lit.addSucceedingComment("%* ModificationNote: removed strong-negation \"-\" *%");
        }
    }
}

