/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.modificationrules.gringo;

import aspmodificator.model.LineBase;
import aspmodificator.modificationrules.gringo.AbstractModificationRule;
import aspmodificator.modificationrules.gringo.ModificationRuleTypeEnum;
import aspmodificator.modificationrules.gringo.RuleTargetEnum;
import aspmodificator.parser.gringo.GringoRule;
import aspmodificator.parser.gringo.Literal;
import aspmodificator.parser.gringo.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class RenamePredicateModificationRule
extends AbstractModificationRule {
    public RenamePredicateModificationRule() {
    }

    public RenamePredicateModificationRule(int minApplication, int maxApplication) {
        super(minApplication, maxApplication);
    }

    @Override
    public int apply(List<LineBase> program) {
        HashMap<Literal, List<Literal>> substitutions = this.findEquivalentSubstitutions(program, Predicate.class);
        if (substitutions == null || substitutions.size() == 0) {
            return 0;
        }
        List<Literal> applicableObject = this.findApplicableObjects(program, substitutions.keySet());
        if (applicableObject.size() == 0) {
            return 0;
        }
        int ruleApplied = 0;
        double chance = (double)(this.minApplication + this.maxApplication) / (double)(2 * applicableObject.size());
        int applicableObjectNo = applicableObject.size();
        block0: while (applicableObjectNo > 0 && ruleApplied < this.maxApplication && ruleApplied < this.minApplication) {
            applicableObjectNo = applicableObject.size();
            int objectIndex = -1;
            for (Literal lit : applicableObject) {
                ++objectIndex;
                if (lit.isModified()) {
                    --applicableObjectNo;
                    continue;
                }
                if (this.useMemory && this.tabuList.isTabu(this.getRuleTypeEnum(), lit.getLineNo(), objectIndex)) {
                    --applicableObjectNo;
                    continue;
                }
                double randomValue = this.random.nextDouble();
                if (!(randomValue <= chance)) continue;
                this.modifyLiteral(lit, substitutions);
                lit.setModified(true);
                ++ruleApplied;
                --applicableObjectNo;
                if (this.useMemory) {
                    this.tabuList.setTabu(this.getRuleTypeEnum(), lit.getLineNo(), objectIndex);
                }
                if (ruleApplied == this.maxApplication) continue block0;
            }
        }
        return ruleApplied;
    }

    private boolean contains(Set<Literal> literalSet, Literal l) {
        for (Literal lit : literalSet) {
            if (!lit.equalSignature(l)) continue;
            return true;
        }
        return false;
    }

    private List<Literal> findApplicableObjects(List<LineBase> program, Set<Literal> keySet) {
        ArrayList<Literal> result = new ArrayList<Literal>();
        for (LineBase line : program) {
            if (!GringoRule.class.isAssignableFrom(line.getClass())) continue;
            GringoRule rule = (GringoRule)line;
            if (rule.getHead() != null && (this.mrRuleTarget == RuleTargetEnum.ALL || this.mrRuleTarget == RuleTargetEnum.HEAD)) {
                for (Literal lit : rule.getHead()) {
                    if (!this.contains(keySet, lit)) continue;
                    result.add(lit);
                }
            }
            if (rule.getBody() == null || this.mrRuleTarget != RuleTargetEnum.ALL && this.mrRuleTarget != RuleTargetEnum.BODY) continue;
            for (Literal lit : rule.getBody()) {
                if (!this.contains(keySet, lit)) continue;
                result.add(lit);
            }
        }
        return result;
    }

    private HashMap<Literal, List<Literal>> findEquivalentSubstitutions(List<LineBase> program, Class<?> clazz) {
        HashMap<Literal, List<Literal>> result = new HashMap<Literal, List<Literal>>();
        for (LineBase line : program) {
            List<Literal> tmpList;
            if (!GringoRule.class.isAssignableFrom(line.getClass())) continue;
            GringoRule rule = (GringoRule)line;
            if (rule.getHead() != null) {
                for (Literal lit : rule.getHead()) {
                    tmpList = Literal.findClassesByType(clazz, lit);
                    for (Literal l : tmpList) {
                        if (this.contains(result.keySet(), l)) continue;
                        result.put(l, new ArrayList());
                    }
                }
            }
            if (rule.getBody() == null) continue;
            for (Literal lit : rule.getBody()) {
                tmpList = Literal.findClassesByType(clazz, lit);
                for (Literal l : tmpList) {
                    if (this.contains(result.keySet(), l)) continue;
                    result.put(l, new ArrayList());
                }
            }
        }
        for (Literal lit : result.keySet()) {
            for (Literal lit2 : result.keySet()) {
                if (lit == lit2 || lit.getArity() != lit2.getArity()) continue;
                result.get(lit).add(lit2);
            }
        }
        LinkedList<Literal> toRemove = new LinkedList<Literal>();
        for (Literal lit : result.keySet()) {
            if (((List)result.get(lit)).size() == 0) {
                toRemove.add(lit);
                continue;
            }
            Collections.sort(result.get(lit), new Comparator<Literal>(){

                @Override
                public int compare(Literal arg0, Literal arg1) {
                    if (arg0.getIdentifier() == null) {
                        return -1;
                    }
                    if (arg1.getIdentifier() == null) {
                        return 1;
                    }
                    return arg0.getIdentifier().compareTo(arg1.getIdentifier());
                }
            });
        }
        for (Literal lit : toRemove) {
            result.remove(lit);
        }
        return result;
    }

    @Override
    public ModificationRuleTypeEnum getRuleTypeEnum() {
        return ModificationRuleTypeEnum.LRP;
    }

    private void modifyLiteral(Literal lit, HashMap<Literal, List<Literal>> substitutions) {
        List<Literal> possSubstitutions = null;
        for (Literal l : substitutions.keySet()) {
            if (!l.equalSignature(lit)) continue;
            possSubstitutions = substitutions.get(l);
            break;
        }
        if (possSubstitutions == null || possSubstitutions.size() == 0) {
            return;
        }
        if (this.writeComments) {
            lit.addSucceedingComment("%*ModificationNote: predicate has been renamed. Original name was " + lit.getIdentifier() + " *%");
        }
        int index = this.random.nextInt(possSubstitutions.size());
        lit.setIdentifier(possSubstitutions.get(index).getIdentifier());
    }
}

