/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.modificationrules.gringo;

import aspmodificator.model.LineBase;
import aspmodificator.modificationrules.gringo.AbstractReplacementLiteralModificationRule;
import aspmodificator.modificationrules.gringo.GringoRuleUtil;
import aspmodificator.modificationrules.gringo.ModificationRuleTypeEnum;
import aspmodificator.modificationrules.gringo.RuleTargetEnum;
import aspmodificator.parser.gringo.GringoRule;
import aspmodificator.parser.gringo.Literal;
import aspmodificator.parser.gringo.Term;
import aspmodificator.parser.gringo.VarTerm;
import common.Pair;
import common.Tripple;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class RenameVariableModificationRule
extends AbstractReplacementLiteralModificationRule<String> {
    protected static final String COMMENT_RENAME_VARIABLE = "%*ModificationNote: variable has been renamed*%";

    public RenameVariableModificationRule() {
    }

    public RenameVariableModificationRule(int minApplication, int maxApplication) {
        super(minApplication, maxApplication);
    }

    @Override
    protected List<Tripple<Literal, Literal, List<String>>> findApplicableObjects(List<LineBase> program) {
        ArrayList<Tripple<Literal, Literal, List<String>>> result = new ArrayList<Tripple<Literal, Literal, List<String>>>();
        for (LineBase line : program) {
            ArrayList<String> values;
            String oldIdentifier;
            List<Pair<Literal, Literal>> litVars;
            VarTerm var2;
            List<VarTerm> vars;
            if (!GringoRule.class.isAssignableFrom(line.getClass())) continue;
            GringoRule rule = (GringoRule)line;
            HashSet<String> variables = new HashSet<String>();
            if (rule.getHead() != null && !rule.getHead().isEmpty()) {
                for (Literal lit : rule.getHead()) {
                    vars = lit.getVariables();
                    if (vars == null || vars.size() <= 0) continue;
                    for (VarTerm var2 : vars) {
                        variables.add(var2.getIdentifier());
                    }
                }
            }
            if (rule.getBody() != null && !rule.getBody().isEmpty()) {
                for (Literal lit : rule.getBody()) {
                    vars = lit.getVariables();
                    if (vars == null || vars.size() <= 0) continue;
                    for (VarTerm var2 : vars) {
                        variables.add(var2.getIdentifier());
                    }
                }
            }
            if (rule.getHead() != null && (this.mrRuleTarget == RuleTargetEnum.ALL || this.mrRuleTarget == RuleTargetEnum.HEAD)) {
                litVars = Literal.findClassesByTypeWithParent(VarTerm.class, rule.getHead(), null);
                for (Pair<Literal, Literal> pair : litVars) {
                    var2 = (VarTerm)pair.getFirst();
                    oldIdentifier = var2.getIdentifier();
                    values = new ArrayList<String>();
                    for (String otherVar : variables) {
                        if (oldIdentifier.equals(otherVar)) continue;
                        var2.setIdentifier(otherVar);
                        if (!GringoRuleUtil.checkSafety(rule)) continue;
                        values.add(otherVar);
                    }
                    var2.setIdentifier(oldIdentifier);
                    if (values.size() <= 0) continue;
                    result.add(new Tripple(var2, pair.getSecond(), values));
                }
            }
            if (rule.getBody() == null || this.mrRuleTarget != RuleTargetEnum.ALL && this.mrRuleTarget != RuleTargetEnum.BODY) continue;
            litVars = Literal.findClassesByTypeWithParent(VarTerm.class, rule.getBody(), null);
            for (Pair<Literal, Literal> pair : litVars) {
                var2 = (VarTerm)pair.getFirst();
                oldIdentifier = var2.getIdentifier();
                values = new ArrayList();
                for (String otherVar : variables) {
                    if (oldIdentifier != null && otherVar != null && oldIdentifier.equals(otherVar)) continue;
                    var2.setIdentifier(otherVar);
                    if (!GringoRuleUtil.checkSafety(rule)) continue;
                    values.add(otherVar);
                }
                var2.setIdentifier(oldIdentifier);
                if (values.size() <= 0) continue;
                result.add(new Tripple(var2, pair.getSecond(), values));
            }
        }
        return result;
    }

    @Override
    public ModificationRuleTypeEnum getRuleTypeEnum() {
        return ModificationRuleTypeEnum.TRV;
    }

    @Override
    protected Literal modifyLiteral(Tripple<Literal, Literal, List<String>> tripple, int index) {
        Term newLit = new Term(tripple.getThird().get(index), tripple.getFirst().getLineNo());
        if (this.writeComments) {
            newLit.addSucceedingComment(COMMENT_RENAME_VARIABLE);
        }
        return newLit;
    }
}

