/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.modificationrules.gringo;

import aspmodificator.model.LineBase;
import aspmodificator.modificationrules.gringo.AbstractReplacementLiteralModificationRule;
import aspmodificator.modificationrules.gringo.ModificationRuleTypeEnum;
import aspmodificator.modificationrules.gringo.RuleTargetEnum;
import aspmodificator.parser.gringo.ConstTerm;
import aspmodificator.parser.gringo.GringoRule;
import aspmodificator.parser.gringo.Literal;
import aspmodificator.parser.gringo.Term;
import common.Pair;
import common.Tripple;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ReplaceConstantModificationRule
extends AbstractReplacementLiteralModificationRule<String> {
    public ReplaceConstantModificationRule() {
    }

    public ReplaceConstantModificationRule(int minApplication, int maxApplication) {
        super(minApplication, maxApplication);
    }

    @Override
    protected List<Tripple<Literal, Literal, List<String>>> findApplicableObjects(List<LineBase> program) {
        ArrayList<Tripple<Literal, Literal, List<String>>> result = new ArrayList<Tripple<Literal, Literal, List<String>>>();
        HashSet<String> constNames = new HashSet<String>();
        HashSet<String> integerNames = new HashSet<String>();
        for (LineBase line : program) {
            List<Literal> tmpList;
            if (!GringoRule.class.isAssignableFrom(line.getClass())) continue;
            GringoRule rule = (GringoRule)line;
            if (rule.getHead() != null) {
                for (Literal lit : rule.getHead()) {
                    if (lit.isModified()) continue;
                    tmpList = Literal.findClassesByType(Term.class, lit);
                    for (Literal mt : tmpList) {
                        constNames.add(mt.getIdentifier());
                        if (mt.isModified() || this.mrRuleTarget != RuleTargetEnum.ALL && this.mrRuleTarget != RuleTargetEnum.HEAD) continue;
                        result.add(new Tripple(mt, null, new ArrayList()));
                    }
                    tmpList = Literal.findClassesByType(ConstTerm.class, lit);
                    for (Literal mt : tmpList) {
                        constNames.add(mt.getIdentifier());
                        integerNames.add(mt.getIdentifier());
                        if (mt.isModified() || this.mrRuleTarget != RuleTargetEnum.ALL && this.mrRuleTarget != RuleTargetEnum.HEAD) continue;
                        result.add(new Tripple(mt, null, new ArrayList()));
                    }
                }
            }
            if (rule.getBody() == null) continue;
            for (Literal lit : rule.getBody()) {
                if (lit.isModified()) continue;
                tmpList = Literal.findClassesByType(Term.class, lit);
                for (Literal mt : tmpList) {
                    constNames.add(mt.getIdentifier());
                    if (mt.isModified() || this.mrRuleTarget != RuleTargetEnum.ALL && this.mrRuleTarget != RuleTargetEnum.BODY) continue;
                    result.add(new Tripple(mt, null, new ArrayList()));
                }
                tmpList = Literal.findClassesByType(ConstTerm.class, lit);
                for (Literal mt : tmpList) {
                    constNames.add(mt.getIdentifier());
                    integerNames.add(mt.getIdentifier());
                    if (mt.isModified() || this.mrRuleTarget != RuleTargetEnum.ALL && this.mrRuleTarget != RuleTargetEnum.BODY) continue;
                    result.add(new Tripple(mt, null, new ArrayList()));
                }
            }
        }
        ArrayList<Tripple> removeList = new ArrayList<Tripple>();
        for (Tripple tripple : result) {
            if (integerNames.contains(((Literal)tripple.getFirst()).getIdentifier())) {
                integerNames.remove(((Literal)tripple.getFirst()).getIdentifier());
                if (integerNames.isEmpty()) {
                    removeList.add(tripple);
                } else {
                    ((List)tripple.getThird()).addAll(integerNames);
                }
                integerNames.add(((Literal)tripple.getFirst()).getIdentifier());
                continue;
            }
            constNames.remove(((Literal)tripple.getFirst()).getIdentifier());
            if (constNames.isEmpty()) {
                removeList.add(tripple);
            } else {
                ((List)tripple.getThird()).addAll(constNames);
            }
            constNames.add(((Literal)tripple.getFirst()).getIdentifier());
        }
        result.removeAll(removeList);
        return result;
    }

    @Override
    public ModificationRuleTypeEnum getRuleTypeEnum() {
        return ModificationRuleTypeEnum.TRC;
    }

    protected void modifyLiteral(Pair<Literal, List<String>> pair) {
    }

    @Override
    protected Literal modifyLiteral(Tripple<Literal, Literal, List<String>> tripple, int index) {
        Term constTerm = (Term)tripple.getFirst();
        if (this.writeComments) {
            constTerm.addSucceedingComment("%* ModificationNote: constant has been renamed. Original name was \"" + constTerm.getIdentifier() + "\" *%");
        }
        constTerm.setIdentifier(tripple.getThird().get(index));
        return constTerm;
    }
}

