/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.modificationrules.gringo;

import aspmodificator.model.LineBase;
import aspmodificator.modificationrules.gringo.AbstractModificationRule;
import aspmodificator.modificationrules.gringo.ModificationRuleTypeEnum;
import aspmodificator.modificationrules.gringo.RuleTargetEnum;
import aspmodificator.parser.gringo.GringoRule;
import aspmodificator.parser.gringo.Literal;
import aspmodificator.parser.gringo.Predicate;
import common.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public class ReplaceLiteralModificationRule
extends AbstractModificationRule {
    public ReplaceLiteralModificationRule() {
    }

    public ReplaceLiteralModificationRule(int minApplication, int maxApplication) {
        super(minApplication, maxApplication);
    }

    @Override
    public int apply(List<LineBase> program) {
        List<Pair<Literal, List<Literal>>> applicableObjectPairs = this.findApplicableObjects(program);
        if (applicableObjectPairs.size() == 0) {
            return 0;
        }
        int ruleApplied = 0;
        double chance = (double)(this.minApplication + this.maxApplication) / (double)(2 * applicableObjectPairs.size());
        int applicableObjectNo = applicableObjectPairs.size();
        block0: while (applicableObjectNo > 0 && ruleApplied < this.maxApplication && ruleApplied < this.minApplication) {
            applicableObjectNo = applicableObjectPairs.size();
            int objectIndex = -1;
            for (Pair<Literal, List<Literal>> pair : applicableObjectPairs) {
                ++objectIndex;
                if (pair.getFirst().isModified()) {
                    --applicableObjectNo;
                    continue;
                }
                if (this.useMemory && this.tabuList.isTabu(ModificationRuleTypeEnum.LRP, pair.getFirst().getLineNo(), objectIndex)) {
                    --applicableObjectNo;
                    continue;
                }
                double randomValue = this.random.nextDouble();
                if (!(randomValue <= chance)) continue;
                this.modifyLiteral(pair);
                ++ruleApplied;
                --applicableObjectNo;
                if (this.useMemory) {
                    this.tabuList.setTabu(ModificationRuleTypeEnum.LRP, pair.getFirst().getLineNo(), objectIndex);
                }
                if (ruleApplied == this.maxApplication) continue block0;
            }
        }
        return ruleApplied;
    }

    protected List<Pair<Literal, List<Literal>>> findApplicableObjects(List<LineBase> program) {
        ArrayList<Pair<Literal, List<Literal>>> result = new ArrayList<Pair<Literal, List<Literal>>>();
        HashSet<Literal> predicates = new HashSet<Literal>();
        for (LineBase lineBase : program) {
            List<Literal> tmpList;
            if (!GringoRule.class.isAssignableFrom(lineBase.getClass())) continue;
            GringoRule rule = (GringoRule)lineBase;
            if (rule.getHead() != null) {
                for (Literal lit : rule.getHead()) {
                    if (lit.isModified()) continue;
                    tmpList = Literal.findClassesByType(Predicate.class, lit);
                    for (Literal mt : tmpList) {
                        if (mt.getVariables() != null) continue;
                        predicates.add(mt);
                        if (mt.isModified() || this.mrRuleTarget != RuleTargetEnum.ALL && this.mrRuleTarget != RuleTargetEnum.HEAD) continue;
                        result.add(new Pair(mt, new ArrayList()));
                    }
                }
            }
            if (rule.getBody() == null) continue;
            for (Literal lit : rule.getBody()) {
                if (lit.isModified()) continue;
                tmpList = Literal.findClassesByType(Predicate.class, lit);
                for (Literal mt : tmpList) {
                    if (mt.getVariables() != null) continue;
                    predicates.add(mt);
                    if (mt.isModified() || this.mrRuleTarget != RuleTargetEnum.ALL && this.mrRuleTarget != RuleTargetEnum.BODY) continue;
                    result.add(new Pair(mt, new ArrayList()));
                }
            }
        }
        this.removeDuplicates(predicates);
        if (predicates.size() > 1) {
            for (Pair pair : result) {
                Literal removed = this.removeEqual(predicates, (Literal)pair.getFirst());
                ((List)pair.getSecond()).addAll(predicates);
                Collections.sort((List)pair.getSecond(), new Comparator<Literal>(){

                    @Override
                    public int compare(Literal o1, Literal o2) {
                        return o1.toString().compareTo(o2.toString());
                    }
                });
                if (removed == null) continue;
                predicates.add(removed);
            }
        } else {
            result.clear();
        }
        return result;
    }

    @Override
    public ModificationRuleTypeEnum getRuleTypeEnum() {
        return ModificationRuleTypeEnum.TODO;
    }

    protected void modifyLiteral(Pair<Literal, List<Literal>> pair) {
        Literal predicate = pair.getFirst();
        if (this.writeComments) {
            predicate.addSucceedingComment("%* ModificationNote: predicate has been replaced. Original name was \"" + predicate.toString() + "\" *%");
        }
        int index = -1;
        index = this.random.nextInt(pair.getSecond().size());
        Literal otherPredicate = pair.getSecond().get(index);
        predicate.setIdentifier(otherPredicate.getIdentifier());
        if (predicate.getTerms() != null) {
            predicate.getTerms().clear();
        }
        if (otherPredicate.getTerms() != null) {
            if (predicate.getTerms() == null) {
                predicate.setTerms(new ArrayList<Literal>());
            }
            for (Literal term : otherPredicate.getTerms()) {
                try {
                    predicate.getTerms().add((Literal)term.clone());
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void removeDuplicates(HashSet<Literal> predicates) {
        ArrayList<Literal> toRemoveList = new ArrayList<Literal>();
        for (Literal lit : predicates) {
            if (toRemoveList.contains(lit)) continue;
            for (Literal lit2 : predicates) {
                if (lit == lit2 || !lit.toString().equals(lit2.toString())) continue;
                toRemoveList.add(lit2);
            }
        }
        predicates.removeAll(toRemoveList);
    }

    private Literal removeEqual(HashSet<Literal> predicates, Literal first) {
        for (Literal lit : predicates) {
            if (!lit.toString().equals(first.toString())) continue;
            predicates.remove(lit);
            return lit;
        }
        return null;
    }
}

