/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.modificationrules.gringo;

import aspmodificator.model.LineBase;
import aspmodificator.modificationrules.gringo.AbstractLiteralModificationRule;
import aspmodificator.modificationrules.gringo.ModificationRuleTypeEnum;
import aspmodificator.modificationrules.gringo.RuleTargetEnum;
import aspmodificator.parser.gringo.GringoRule;
import aspmodificator.parser.gringo.Literal;
import aspmodificator.parser.gringo.Predicate;
import java.util.ArrayList;
import java.util.List;

public class SwapStrongNegationModificationRule
extends AbstractLiteralModificationRule {
    public static final String COMMENT_ADDED = "%* ModificationNote: added strong-negation \"-\" *%";
    public static final String COMMENT_REMOVED = "%* ModificationNote: removed strong-negation \"-\" *%";
    protected boolean requireExistingObject = false;

    public SwapStrongNegationModificationRule() {
    }

    public SwapStrongNegationModificationRule(int minApplication, int maxApplication) {
        super(minApplication, maxApplication);
    }

    public SwapStrongNegationModificationRule(int minApplication, int maxApplication, boolean requireExistingPredicate) {
        super(minApplication, maxApplication);
        this.requireExistingObject = requireExistingPredicate;
    }

    @Override
    protected List<Literal> findApplicableObjects(List<LineBase> program) {
        ArrayList<Literal> result = new ArrayList<Literal>();
        for (LineBase line : program) {
            if (!GringoRule.class.isAssignableFrom(line.getClass())) continue;
            GringoRule rule = (GringoRule)line;
            if (rule.getHead() != null) {
                for (Literal lit : rule.getHead()) {
                    if (!Predicate.class.isAssignableFrom(lit.getClass()) || lit.isModified() || this.mrRuleTarget != RuleTargetEnum.ALL && this.mrRuleTarget != RuleTargetEnum.HEAD) continue;
                    result.add(lit);
                }
            }
            if (rule.getBody() == null) continue;
            for (Literal lit : rule.getBody()) {
                if (!Predicate.class.isAssignableFrom(lit.getClass()) || lit.isModified() || this.mrRuleTarget != RuleTargetEnum.ALL && this.mrRuleTarget != RuleTargetEnum.BODY) continue;
                result.add(lit);
            }
        }
        if (this.requireExistingObject) {
            ArrayList<Literal> toRemove = new ArrayList<Literal>();
            for (Literal lit : result) {
                boolean found = false;
                for (Literal lit2 : result) {
                    if (lit == lit2 || lit.getArity() != lit2.getArity()) continue;
                    Predicate pred = (Predicate)lit;
                    Predicate pred2 = (Predicate)lit2;
                    if (pred.isSigned() == pred2.isSigned() || !pred.getIdentifier().equals(pred2.getIdentifier())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                toRemove.add(lit);
            }
            result.removeAll(toRemove);
        }
        return result;
    }

    @Override
    public ModificationRuleTypeEnum getRuleTypeEnum() {
        return ModificationRuleTypeEnum.SSN;
    }

    public boolean isRequireExistingObject() {
        return this.requireExistingObject;
    }

    @Override
    protected void modifyLiteral(Literal lit) {
        Predicate pred;
        pred.setNegated(!(pred = (Predicate)lit).isNegated());
        if (this.writeComments) {
            if (pred.isNegated()) {
                lit.addSucceedingComment(COMMENT_ADDED);
            } else {
                lit.addSucceedingComment(COMMENT_REMOVED);
            }
        }
    }

    public void setRequireExistingObject(boolean requireExistingObject) {
        this.requireExistingObject = requireExistingObject;
    }
}

