/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.modificationrules.gringo;

import aspmodificator.model.LineBase;
import aspmodificator.modificationrules.gringo.AbstractLiteralModificationRule;
import aspmodificator.modificationrules.gringo.ModificationRuleTypeEnum;
import aspmodificator.modificationrules.gringo.RuleTargetEnum;
import aspmodificator.parser.gringo.AggregateLiteral;
import aspmodificator.parser.gringo.GringoRule;
import aspmodificator.parser.gringo.Literal;
import aspmodificator.parser.gringo.RelLit;
import java.util.ArrayList;
import java.util.List;

public class SwapTermModificationRule
extends AbstractLiteralModificationRule {
    public SwapTermModificationRule() {
    }

    public SwapTermModificationRule(int minApplication, int maxApplication) {
        super(minApplication, maxApplication);
    }

    private boolean checkPreconditions(Literal lit) {
        if (RelLit.class.isAssignableFrom(lit.getClass()) && ((RelLit)lit).getIdentifier().equals("=")) {
            return false;
        }
        if (AggregateLiteral.class.equals(lit.getClass())) {
            return false;
        }
        if (lit != null && lit.getTerms() != null && lit.getTerms().size() > 1) {
            for (Literal l1 : lit.getTerms()) {
                boolean foundNoOther = true;
                for (Literal l2 : lit.getTerms()) {
                    if (l1 == l2 || l1.toString().equals(l2.toString())) continue;
                    foundNoOther = false;
                    break;
                }
                if (!foundNoOther) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected List<Literal> findApplicableObjects(List<LineBase> program) {
        ArrayList<Literal> result = new ArrayList<Literal>();
        for (LineBase line : program) {
            if (!GringoRule.class.isAssignableFrom(line.getClass())) continue;
            GringoRule rule = (GringoRule)line;
            if (rule.getHead() != null && (this.mrRuleTarget == RuleTargetEnum.ALL || this.mrRuleTarget == RuleTargetEnum.HEAD)) {
                for (Literal lit : rule.getHead()) {
                    if (!this.checkPreconditions(lit) || lit.isModified()) continue;
                    result.add(lit);
                }
            }
            if (rule.getBody() == null || this.mrRuleTarget != RuleTargetEnum.ALL && this.mrRuleTarget != RuleTargetEnum.BODY) continue;
            for (Literal lit : rule.getBody()) {
                if (!this.checkPreconditions(lit) || lit.isModified()) continue;
                result.add(lit);
            }
        }
        return result;
    }

    @Override
    public ModificationRuleTypeEnum getRuleTypeEnum() {
        return ModificationRuleTypeEnum.TST;
    }

    @Override
    protected void modifyLiteral(Literal lit) {
        if (this.writeComments) {
            String original = lit.toString();
            lit.addSucceedingComment("%* ModificationNote: Terms have been swapped. Original literal: " + original + "*%");
        }
        if (lit.getTerms().size() > 2) {
            int index1 = this.random.nextInt(lit.getTerms().size());
            int index2 = this.random.nextInt(lit.getTerms().size());
            Literal l1 = lit.getTerms().get(index1);
            Literal l2 = lit.getTerms().get(index2);
            while (index1 == index2 && l1.toString().equals(l2.toString())) {
                index2 = this.random.nextInt(lit.getTerms().size());
                l1 = lit.getTerms().get(index1);
                l2 = lit.getTerms().get(index2);
            }
            lit.getTerms().remove(index1);
            lit.getTerms().add(index1, l2);
            lit.getTerms().remove(index2);
            lit.getTerms().add(index2, l1);
        } else {
            Literal tmp = lit.getTerms().remove(0);
            lit.getTerms().add(tmp);
        }
    }
}

