/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.modificationrules.gringo;

import aspmodificator.model.LineBase;
import aspmodificator.modificationrules.gringo.AbstractLiteralModificationRule;
import aspmodificator.modificationrules.gringo.GringoRuleUtil;
import aspmodificator.modificationrules.gringo.ModificationRuleTypeEnum;
import aspmodificator.parser.gringo.GringoRule;
import aspmodificator.parser.gringo.Literal;
import aspmodificator.parser.gringo.RelLit;
import aspmodificator.parser.gringo.Term;
import java.util.ArrayList;
import java.util.List;

public class SwitchDefaultNegationModificationRule
extends AbstractLiteralModificationRule {
    public static final String COMMENT_ADDED = "%*ModificationNote: added default-negation \"not\" *%";
    public static final String COMMENT_REMOVED = "%*ModificationNote: removed default-negation \"not\" *%";

    public SwitchDefaultNegationModificationRule() {
    }

    public SwitchDefaultNegationModificationRule(int minApplication, int maxApplication) {
        super(minApplication, maxApplication);
    }

    protected boolean allowsDefaultNegation(Class<? extends Literal> clazz) {
        if (Term.class.isAssignableFrom(clazz)) {
            return false;
        }
        return !RelLit.class.isAssignableFrom(clazz);
    }

    @Override
    protected List<Literal> findApplicableObjects(List<LineBase> program) {
        ArrayList<Literal> result = new ArrayList<Literal>();
        for (LineBase line : program) {
            GringoRule rule;
            if (!GringoRule.class.isAssignableFrom(line.getClass()) || (rule = (GringoRule)line).getBody() == null) continue;
            for (Literal lit : rule.getBody()) {
                if (!this.allowsDefaultNegation(lit.getClass()) || lit.isModified()) continue;
                if (!lit.isSigned()) {
                    lit.setSigned(true);
                    if (GringoRuleUtil.checkSafety(rule)) {
                        result.add(lit);
                    }
                    lit.setSigned(false);
                    continue;
                }
                result.add(lit);
            }
        }
        return result;
    }

    @Override
    public ModificationRuleTypeEnum getRuleTypeEnum() {
        return ModificationRuleTypeEnum.SDN;
    }

    @Override
    protected void modifyLiteral(Literal lit) {
        lit.setSigned(!lit.isSigned());
        if (this.writeComments) {
            if (lit.isSigned()) {
                lit.addSucceedingComment(COMMENT_ADDED);
            } else {
                lit.addSucceedingComment(COMMENT_REMOVED);
            }
        }
    }
}

