/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.modificationrules.gringo;

import aspmodificator.model.LineBase;
import aspmodificator.modificationrules.gringo.AbstractLiteralModificationRule;
import aspmodificator.modificationrules.gringo.ModificationRuleTypeEnum;
import aspmodificator.modificationrules.gringo.RuleTargetEnum;
import aspmodificator.parser.gringo.AggregatLiteralBracketsEnum;
import aspmodificator.parser.gringo.AggregateLiteral;
import aspmodificator.parser.gringo.CondLit;
import aspmodificator.parser.gringo.ConstTerm;
import aspmodificator.parser.gringo.GringoRule;
import aspmodificator.parser.gringo.Literal;
import aspmodificator.parser.gringo.MathTerm;
import java.util.ArrayList;
import java.util.List;

public class TwiddleAggregateWeightsModificationRule
extends AbstractLiteralModificationRule {
    public static final String COMMENT_TWIDDL_WEIGHTS_INC = "%*ModificationNote: Weight increased by 1 *%";
    public static final String COMMENT_TWIDDL_WEIGHTS_DEC = "%*ModificationNote: Weight decreased by 1 *%";

    public TwiddleAggregateWeightsModificationRule() {
    }

    public TwiddleAggregateWeightsModificationRule(int minApplication, int maxApplication) {
        super(minApplication, maxApplication);
    }

    @Override
    protected List<Literal> findApplicableObjects(List<LineBase> program) {
        ArrayList<Literal> result = new ArrayList<Literal>();
        for (LineBase line : program) {
            CondLit cl;
            List<Literal> tmpList;
            AggregateLiteral aggLit;
            if (!GringoRule.class.isAssignableFrom(line.getClass())) continue;
            GringoRule rule = (GringoRule)line;
            if (rule.getHead() != null && (this.mrRuleTarget == RuleTargetEnum.ALL || this.mrRuleTarget == RuleTargetEnum.HEAD)) {
                for (Literal lit : rule.getHead()) {
                    if (lit.isModified() || !AggregateLiteral.class.isAssignableFrom(lit.getClass()) || (aggLit = (AggregateLiteral)lit).getBrackets() == AggregatLiteralBracketsEnum.BRACETS_CURLY) continue;
                    tmpList = Literal.findClassesByType(CondLit.class, lit);
                    for (Literal mt : tmpList) {
                        cl = (CondLit)mt;
                        if (mt.isModified() || cl.hasDefaultWeight()) continue;
                        result.add(mt);
                    }
                }
            }
            if (rule.getBody() == null || this.mrRuleTarget != RuleTargetEnum.ALL && this.mrRuleTarget != RuleTargetEnum.BODY) continue;
            for (Literal lit : rule.getBody()) {
                if (lit.isModified() || !AggregateLiteral.class.isAssignableFrom(lit.getClass()) || (aggLit = (AggregateLiteral)lit).getBrackets() == AggregatLiteralBracketsEnum.BRACETS_CURLY) continue;
                tmpList = Literal.findClassesByType(CondLit.class, lit);
                for (Literal mt : tmpList) {
                    cl = (CondLit)mt;
                    if (mt.isModified() || cl.hasDefaultWeight()) continue;
                    result.add(mt);
                }
            }
        }
        return result;
    }

    @Override
    public ModificationRuleTypeEnum getRuleTypeEnum() {
        return ModificationRuleTypeEnum.ATW;
    }

    @Override
    protected void modifyLiteral(Literal lit) {
        CondLit condLit = (CondLit)lit;
        boolean shouldIncrement = this.random.nextBoolean();
        if (ConstTerm.class.isAssignableFrom(condLit.getWeight().getClass())) {
            int value = Integer.valueOf(condLit.getWeight().getIdentifier());
            if (shouldIncrement || value == 1) {
                condLit.getWeight().setIdentifier(Integer.toString(value + 1));
                if (this.writeComments) {
                    condLit.getWeight().addSucceedingComment(COMMENT_TWIDDL_WEIGHTS_INC);
                }
            } else {
                condLit.getWeight().setIdentifier(Integer.toString(value - 1));
                if (this.writeComments) {
                    condLit.getWeight().addSucceedingComment(COMMENT_TWIDDL_WEIGHTS_DEC);
                }
            }
        } else {
            MathTerm mathTerm;
            if (shouldIncrement) {
                mathTerm = new MathTerm("+", condLit.getWeight(), new ConstTerm(1, lit.getLineNo()), lit.getLineNo());
                if (this.writeComments) {
                    condLit.getWeight().addSucceedingComment(COMMENT_TWIDDL_WEIGHTS_INC);
                }
            } else {
                mathTerm = new MathTerm("-", condLit.getWeight(), new ConstTerm(1, lit.getLineNo()), lit.getLineNo());
                if (this.writeComments) {
                    condLit.getWeight().addSucceedingComment(COMMENT_TWIDDL_WEIGHTS_DEC);
                }
            }
            condLit.setWeight(mathTerm);
        }
    }
}

