/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.modificationrules.gringo;

import aspmodificator.model.LineBase;
import aspmodificator.modificationrules.gringo.AbstractModificationRule;
import aspmodificator.modificationrules.gringo.ModificationRuleTypeEnum;
import aspmodificator.modificationrules.gringo.RuleTargetEnum;
import aspmodificator.parser.gringo.ConstTerm;
import aspmodificator.parser.gringo.GringoRule;
import aspmodificator.parser.gringo.Literal;
import aspmodificator.parser.gringo.MathTerm;
import aspmodificator.parser.gringo.RelLit;
import java.util.ArrayList;
import java.util.List;

public class TwiddleMathStatementModificationRule
extends AbstractModificationRule {
    public boolean includeMathTerms = true;
    public boolean includeRelLiterals = true;
    public static final String COMMENT_TWIDDLEMATH_INC = "%*ModificationNote: +1 added *%";
    public static final String COMMENT_TWIDDLEMATH_DEC = "%*ModificationNote: -1 added *%";

    public TwiddleMathStatementModificationRule() {
    }

    public TwiddleMathStatementModificationRule(int min, int max) {
        super(min, max);
    }

    public TwiddleMathStatementModificationRule(int minApplication, int maxApplication, boolean includeRelations, boolean includeMathTerms) {
        this(minApplication, maxApplication);
        this.includeMathTerms = includeMathTerms;
        this.includeRelLiterals = includeRelations;
    }

    @Override
    public int apply(List<LineBase> program) {
        List<Literal> applicableObject = this.findApplicableObjects(program);
        if (applicableObject.size() == 0) {
            return 0;
        }
        int ruleApplied = 0;
        double chance = (double)(this.minApplication + this.maxApplication) / (double)(2 * applicableObject.size());
        int applicableObjectNo = applicableObject.size();
        block0: while (applicableObjectNo > 0 && ruleApplied < this.maxApplication && ruleApplied < this.minApplication) {
            applicableObjectNo = applicableObject.size();
            int objectIndex = -1;
            for (Literal lit : applicableObject) {
                ++objectIndex;
                if (lit.isModified()) {
                    --applicableObjectNo;
                    continue;
                }
                double randomValue = this.random.nextDouble();
                if (!(randomValue <= chance)) continue;
                int termSize = lit.getTerms().size();
                int choosenIndex = this.random.nextInt(termSize);
                boolean shouldIncrement = this.random.nextBoolean();
                choosenIndex = this.preventIllegalAssignment(lit, choosenIndex);
                if (this.useMemory && shouldIncrement) {
                    choosenIndex += termSize;
                }
                int tries = 0;
                int maxTries = termSize * 2;
                while (this.useMemory && this.tabuList.isTabu(this.getRuleTypeEnum(), lit.getLineNo(), objectIndex, choosenIndex) && tries < maxTries) {
                    choosenIndex = this.random.nextInt(termSize);
                    shouldIncrement = this.random.nextBoolean();
                    choosenIndex = this.preventIllegalAssignment(lit, choosenIndex);
                    if (shouldIncrement) {
                        choosenIndex += termSize;
                    }
                    ++tries;
                }
                if (this.useMemory && this.tabuList.isTabu(this.getRuleTypeEnum(), lit.getLineNo(), objectIndex, choosenIndex)) {
                    --applicableObjectNo;
                    continue;
                }
                if (this.useMemory && shouldIncrement) {
                    choosenIndex -= termSize;
                }
                this.modifyLiteral(lit, choosenIndex, shouldIncrement);
                lit.setModified(true);
                ++ruleApplied;
                --applicableObjectNo;
                if (this.useMemory) {
                    if (shouldIncrement) {
                        choosenIndex += termSize;
                    }
                    this.tabuList.setTabu(this.getRuleTypeEnum(), lit.getLineNo(), objectIndex, choosenIndex);
                }
                if (ruleApplied == this.maxApplication) continue block0;
            }
        }
        return ruleApplied;
    }

    protected List<Literal> findApplicableObjects(List<LineBase> program) {
        ArrayList<Literal> result = new ArrayList<Literal>();
        for (LineBase line : program) {
            List<Literal> tmpList;
            if (!GringoRule.class.isAssignableFrom(line.getClass())) continue;
            GringoRule rule = (GringoRule)line;
            if (rule.getHead() != null && (this.mrRuleTarget == RuleTargetEnum.ALL || this.mrRuleTarget == RuleTargetEnum.HEAD)) {
                for (Literal lit : rule.getHead()) {
                    if (lit.isModified()) continue;
                    if (this.includeMathTerms) {
                        tmpList = Literal.findClassesByType(MathTerm.class, lit);
                        for (Literal mt : tmpList) {
                            if (mt.isModified()) continue;
                            result.add(mt);
                        }
                    }
                    if (!this.includeRelLiterals) continue;
                    tmpList = Literal.findClassesByType(RelLit.class, lit);
                    for (Literal mt : tmpList) {
                        if (mt.isModified()) continue;
                        result.add(mt);
                    }
                }
            }
            if (rule.getBody() == null || this.mrRuleTarget != RuleTargetEnum.ALL && this.mrRuleTarget != RuleTargetEnum.BODY) continue;
            for (Literal lit : rule.getBody()) {
                if (lit.isModified()) continue;
                if (this.includeMathTerms) {
                    tmpList = Literal.findClassesByType(MathTerm.class, lit);
                    for (Literal mt : tmpList) {
                        if (mt.isModified()) continue;
                        result.add(mt);
                    }
                }
                if (!this.includeRelLiterals) continue;
                tmpList = Literal.findClassesByType(RelLit.class, lit);
                for (Literal mt : tmpList) {
                    if (mt.isModified()) continue;
                    result.add(mt);
                }
            }
        }
        return result;
    }

    @Override
    public ModificationRuleTypeEnum getRuleTypeEnum() {
        return ModificationRuleTypeEnum.ATV;
    }

    public boolean isIncludeMathTerms() {
        return this.includeMathTerms;
    }

    public boolean isIncludeRelLiterals() {
        return this.includeRelLiterals;
    }

    protected void modifyLiteral(Literal lit, int toChangeIndex, boolean shouldIncrement) {
        MathTerm mathTerm;
        List<Literal> terms = lit.getTerms();
        Literal orig = terms.get(toChangeIndex);
        if (shouldIncrement) {
            mathTerm = new MathTerm("+", orig, new ConstTerm(1, lit.getLineNo()), lit.getLineNo());
            if (this.writeComments) {
                mathTerm.addPrecedingComment(COMMENT_TWIDDLEMATH_INC);
            }
        } else {
            mathTerm = new MathTerm("-", orig, new ConstTerm(1, lit.getLineNo()), lit.getLineNo());
            if (this.writeComments) {
                mathTerm.addPrecedingComment(COMMENT_TWIDDLEMATH_DEC);
            }
        }
        terms.set(toChangeIndex, mathTerm);
    }

    private int preventIllegalAssignment(Literal lit, int choosenIndex) {
        if ((lit.getIdentifier() == "=" || lit.getIdentifier() == ":=") && lit.getTerms().get(choosenIndex).getArity() == 0 && lit.getTerms().get(1 - choosenIndex).getArity() == 2) {
            choosenIndex = 1 - choosenIndex;
        }
        return choosenIndex;
    }

    public void setIncludeMathTerms(boolean includeMathTerms) {
        this.includeMathTerms = includeMathTerms;
    }

    public void setIncludeRelLiterals(boolean includeRelLiterals) {
        this.includeRelLiterals = includeRelLiterals;
    }
}

