/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.modificationrules.gringo;

import aspmodificator.model.LineBase;
import aspmodificator.modificationrules.gringo.AbstractComplexLiteralModificationRule;
import aspmodificator.modificationrules.gringo.GringoRuleUtil;
import aspmodificator.modificationrules.gringo.ModificationRuleTypeEnum;
import aspmodificator.modificationrules.gringo.RuleTargetEnum;
import aspmodificator.parser.gringo.GringoRule;
import aspmodificator.parser.gringo.Literal;
import aspmodificator.parser.gringo.RelLit;
import aspmodificator.parser.gringo.Term;
import aspmodificator.parser.gringo.VarTerm;
import common.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;

public class VariableToConstantModificationRule
extends AbstractComplexLiteralModificationRule {
    protected static final String COMMENT_VARIABLE_TO_CONSTANT = "%*ModificationNote: term has been modified from a variable to a constant*%";
    protected RuleTargetEnum existenceCheckTarget = RuleTargetEnum.NONE;

    public VariableToConstantModificationRule() {
    }

    public VariableToConstantModificationRule(int minApplication, int maxApplication) {
        super(minApplication, maxApplication);
    }

    @Override
    public int apply(List<LineBase> program) {
        ArrayList<String> constantNames = null;
        if (this.existenceCheckTarget != RuleTargetEnum.NONE) {
            HashSet<String> constTermList = new HashSet<String>();
            for (LineBase line : program) {
                List<Literal> tmpList;
                if (!GringoRule.class.isAssignableFrom(line.getClass())) continue;
                GringoRule rule = (GringoRule)line;
                if (rule.getHead() != null) {
                    for (Literal lit : rule.getHead()) {
                        tmpList = Literal.findClassesByType(Term.class, lit);
                        for (Literal l : tmpList) {
                            constTermList.add(l.getIdentifier());
                        }
                    }
                }
                if (rule.getBody() == null) continue;
                for (Literal lit : rule.getBody()) {
                    tmpList = Literal.findClassesByType(Term.class, lit);
                    for (Literal l : tmpList) {
                        constTermList.add(l.getIdentifier());
                    }
                }
            }
            if (constTermList.isEmpty() && this.existenceCheckTarget == RuleTargetEnum.ALL) {
                return 0;
            }
            constantNames = new ArrayList<String>(constTermList);
        }
        ArrayList<Pair<Literal, Literal>> applicableObjectPairs = new ArrayList<Pair<Literal, Literal>>();
        RuleTargetEnum originalTarget = this.mrRuleTarget;
        if (originalTarget == RuleTargetEnum.ALL || originalTarget == RuleTargetEnum.HEAD) {
            this.mrRuleTarget = RuleTargetEnum.HEAD;
            applicableObjectPairs.addAll(this.findApplicableObjects(program));
        }
        int noHeadConstants = applicableObjectPairs.size();
        if (originalTarget == RuleTargetEnum.ALL || originalTarget == RuleTargetEnum.BODY) {
            this.mrRuleTarget = RuleTargetEnum.BODY;
            applicableObjectPairs.addAll(this.findApplicableObjects(program));
        }
        this.mrRuleTarget = originalTarget;
        int applicableObjectNo = applicableObjectPairs.size();
        if (applicableObjectNo == 0) {
            return 0;
        }
        int ruleApplied = 0;
        double chance = (double)(this.minApplication + this.maxApplication) / (double)(2 * applicableObjectNo);
        block5: while (applicableObjectNo > 0 && ruleApplied < this.maxApplication && ruleApplied < this.minApplication) {
            applicableObjectNo = applicableObjectPairs.size();
            int objectIndex = -1;
            for (Pair pair : applicableObjectPairs) {
                Literal newLiteral;
                ++objectIndex;
                if (((Literal)pair.getFirst()).isModified()) {
                    --applicableObjectNo;
                    continue;
                }
                if (this.useMemory && this.tabuList.isTabu(this.getRuleTypeEnum(), ((Literal)pair.getFirst()).getLineNo(), objectIndex)) {
                    --applicableObjectNo;
                    continue;
                }
                double randomValue = this.random.nextDouble();
                if (!(randomValue <= chance)) continue;
                if (this.existenceCheckTarget == RuleTargetEnum.NONE) {
                    newLiteral = this.modifyLiteral(pair);
                } else if (objectIndex < noHeadConstants && this.existenceCheckTarget == RuleTargetEnum.BODY || objectIndex >= noHeadConstants && this.existenceCheckTarget == RuleTargetEnum.HEAD) {
                    String name = String.valueOf(((Literal)pair.getFirst()).getIdentifier().substring(0, 1).toLowerCase()) + ((Literal)pair.getFirst()).getIdentifier().substring(1);
                    boolean contains = constantNames.contains(name);
                    constantNames.add(name);
                    newLiteral = this.modifyLiteral(pair, constantNames);
                    if (!contains) {
                        constantNames.remove(name);
                    }
                } else {
                    newLiteral = this.modifyLiteral(pair, constantNames);
                }
                int index = ((Literal)pair.getSecond()).getTerms().indexOf(pair.getFirst());
                if (index >= 0) {
                    ((Literal)pair.getSecond()).getTerms().remove(index);
                }
                if (newLiteral != null) {
                    ((Literal)pair.getSecond()).getTerms().add(index, newLiteral);
                    newLiteral.setModified(true);
                }
                ++ruleApplied;
                --applicableObjectNo;
                if (this.useMemory) {
                    this.tabuList.setTabu(this.getRuleTypeEnum(), ((Literal)pair.getFirst()).getLineNo(), objectIndex);
                }
                if (ruleApplied == this.maxApplication) continue block5;
            }
        }
        return ruleApplied;
    }

    private boolean checkParentPreconditions(Literal parent) {
        return !parent.getClass().equals(RelLit.class);
    }

    private boolean checkPreconditions(Literal lit) {
        VarTerm term = (VarTerm)lit;
        if (term.getTerms() != null && term.getTerms().size() > 0) {
            return false;
        }
        return term.getIdentifier() != null && Pattern.matches("[A-Z].*", term.getIdentifier());
    }

    @Override
    protected List<Pair<Literal, Literal>> findApplicableObjects(List<LineBase> program) {
        ArrayList<Pair<Literal, Literal>> result = new ArrayList<Pair<Literal, Literal>>();
        for (LineBase line : program) {
            int index;
            List<Pair<Literal, Literal>> termList;
            if (!GringoRule.class.isAssignableFrom(line.getClass())) continue;
            GringoRule rule = (GringoRule)line;
            if (rule.getHead() != null && (this.mrRuleTarget == RuleTargetEnum.ALL || this.mrRuleTarget == RuleTargetEnum.HEAD)) {
                termList = Literal.findClassesByTypeWithParent(VarTerm.class, rule.getHead(), null);
                for (Pair<Literal, Literal> pair : termList) {
                    if (!this.checkPreconditions(pair.getFirst()) || !this.checkParentPreconditions(pair.getSecond()) || pair.getFirst().isModified()) continue;
                    index = pair.getSecond().getTerms().indexOf(pair.getFirst());
                    pair.getSecond().getTerms().remove(index);
                    if (GringoRuleUtil.checkSafety(rule)) {
                        result.add(pair);
                    }
                    pair.getSecond().getTerms().add(index, pair.getFirst());
                }
            }
            if (rule.getBody() == null || this.mrRuleTarget != RuleTargetEnum.ALL && this.mrRuleTarget != RuleTargetEnum.BODY) continue;
            termList = Literal.findClassesByTypeWithParent(VarTerm.class, rule.getBody(), null);
            for (Pair<Literal, Literal> pair : termList) {
                if (!this.checkPreconditions(pair.getFirst()) || !this.checkParentPreconditions(pair.getSecond()) || pair.getFirst().isModified()) continue;
                index = pair.getSecond().getTerms().indexOf(pair.getFirst());
                pair.getSecond().getTerms().remove(index);
                if (GringoRuleUtil.checkSafety(rule)) {
                    result.add(pair);
                }
                pair.getSecond().getTerms().add(index, pair.getFirst());
            }
        }
        return result;
    }

    public RuleTargetEnum getExistenceCheckTarget() {
        return this.existenceCheckTarget;
    }

    @Override
    public ModificationRuleTypeEnum getRuleTypeEnum() {
        return ModificationRuleTypeEnum.TVC;
    }

    @Override
    protected Literal modifyLiteral(Pair<Literal, Literal> pair) {
        String name = String.valueOf(pair.getFirst().getIdentifier().substring(0, 1).toLowerCase()) + pair.getFirst().getIdentifier().substring(1);
        Term newLit = new Term(name, pair.getFirst().getLineNo());
        if (this.writeComments) {
            newLit.addSucceedingComment(COMMENT_VARIABLE_TO_CONSTANT);
        }
        return newLit;
    }

    private Literal modifyLiteral(Pair<Literal, Literal> pair, List<String> constTermList) {
        String name = constTermList.get(this.random.nextInt(constTermList.size()));
        Term newLit = new Term(name, pair.getFirst().getLineNo());
        if (this.writeComments) {
            newLit.addSucceedingComment(COMMENT_VARIABLE_TO_CONSTANT);
        }
        return newLit;
    }

    public void setExistenceCheckTarget(RuleTargetEnum existenceCheckTarget) {
        this.existenceCheckTarget = existenceCheckTarget;
    }
}

