/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.parser.gringo;

import aspmodificator.parser.gringo.AggregatLiteralBracketsEnum;
import aspmodificator.parser.gringo.BlockComment;
import aspmodificator.parser.gringo.Literal;
import aspmodificator.parser.gringo.Term;
import java.util.ArrayList;
import java.util.List;

public class AggregateLiteral
extends Literal {
    public static final String MIN = "#min";
    public static final String PARITY_ODD = "PARITY_ODD";
    public static final String PARITY_EVEN = "PARITY_EVEN";
    public static final String SUM = "#sum";
    public static final String COUNT = "#count";
    private AggregatLiteralBracketsEnum brackets = null;
    private Term lower;
    private Term upper;

    public AggregateLiteral() {
        this.lower = null;
        this.upper = null;
    }

    public AggregateLiteral(String identifier, List<Literal> terms, AggregatLiteralBracketsEnum brackets, int lineNo) {
        super(identifier, terms, false);
        this.brackets = brackets;
    }

    public AggregateLiteral(String operation, List<Literal> terms, boolean signed, AggregatLiteralBracketsEnum brackets, int lineNo) {
        super(operation, terms, signed, lineNo);
        this.brackets = brackets;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ArrayList<Literal> newTerms = null;
        if (this.terms != null) {
            newTerms = new ArrayList<Literal>();
            for (Literal lit : this.terms) {
                newTerms.add((Literal)lit.clone());
            }
        }
        ArrayList<BlockComment> newPrecedingComments = null;
        if (this.precedingComments != null) {
            newPrecedingComments = new ArrayList<BlockComment>();
            for (BlockComment c : this.precedingComments) {
                newPrecedingComments.add((BlockComment)c.clone());
            }
        }
        ArrayList<BlockComment> newSucceedingComments = null;
        if (this.succeedingComments != null) {
            newSucceedingComments = new ArrayList<BlockComment>();
            for (BlockComment c : this.succeedingComments) {
                newSucceedingComments.add((BlockComment)c.clone());
            }
        }
        String newIdentifier = null;
        if (this.identifier != null) {
            newIdentifier = new String(this.identifier);
        }
        Term newLower = null;
        if (this.lower != null) {
            newLower = (Term)this.lower.clone();
        }
        Term newUpper = null;
        if (this.upper != null) {
            newUpper = (Term)this.upper.clone();
        }
        AggregateLiteral newLit = new AggregateLiteral(newIdentifier, newTerms, this.signed, this.brackets, this.lineNo);
        newLit.setLower(newLower);
        newLit.setUpper(newUpper);
        newLit.setPrecedingComments(newPrecedingComments);
        newLit.setSucceedingComments(newSucceedingComments);
        return newLit;
    }

    public AggregatLiteralBracketsEnum getBrackets() {
        return this.brackets;
    }

    public Term getLower() {
        return this.lower;
    }

    public Term getUpper() {
        return this.upper;
    }

    public void setLower(Term l) {
        this.lower = l;
    }

    public void setUpper(Term u) {
        this.upper = u;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.lower != null) {
            sb.append(this.lower.toString());
            sb.append(" ");
        }
        if (this.identifier != null) {
            sb.append(this.identifier);
            sb.append(" ");
        }
        if (this.brackets == AggregatLiteralBracketsEnum.BRACETS_CURLY) {
            sb.append("{ ");
        } else if (this.brackets == AggregatLiteralBracketsEnum.BRACETS_SQUARE) {
            sb.append("[ ");
        }
        if (this.terms != null && this.terms.size() > 0) {
            int i = 0;
            while (i < this.terms.size() - 1) {
                sb.append(((Literal)this.terms.get(i)).toString());
                sb.append(", ");
                ++i;
            }
            sb.append(((Literal)this.terms.get(this.terms.size() - 1)).toString());
        }
        if (this.brackets == AggregatLiteralBracketsEnum.BRACETS_CURLY) {
            sb.append(" }");
        } else if (this.brackets == AggregatLiteralBracketsEnum.BRACETS_SQUARE) {
            sb.append(" ]");
        }
        if (this.upper != null) {
            sb.append(" ");
            sb.append(this.upper.toString());
        }
        return sb.toString();
    }
}

