/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.parser.gringo;

import aspmodificator.parser.gringo.BlockComment;
import aspmodificator.parser.gringo.ICommentable;
import java.util.ArrayList;
import java.util.List;

public class CommentableObject
implements ICommentable {
    private List<BlockComment> precedingComments = null;
    private List<BlockComment> succeedingComments = null;

    public CommentableObject() {
    }

    public CommentableObject(List<BlockComment> precedingComments, List<BlockComment> succeedingComments) {
        this.precedingComments = precedingComments;
        this.succeedingComments = succeedingComments;
    }

    @Override
    public void addPrecedingComment(String bc) {
        if (this.precedingComments == null) {
            this.precedingComments = new ArrayList<BlockComment>();
        }
        this.precedingComments.add(0, new BlockComment(bc));
    }

    @Override
    public void addSucceedingComment(String bc) {
        if (this.succeedingComments == null) {
            this.succeedingComments = new ArrayList<BlockComment>();
        }
        this.succeedingComments.add(0, new BlockComment(bc));
    }

    protected Object clone() throws CloneNotSupportedException {
        ArrayList<BlockComment> newPrecedingComments = null;
        ArrayList<BlockComment> newSucceedingComments = null;
        if (this.precedingComments != null && this.precedingComments.size() > 0) {
            newPrecedingComments = new ArrayList<BlockComment>();
            for (BlockComment bc : this.precedingComments) {
                newPrecedingComments.add((BlockComment)bc.clone());
            }
        }
        if (this.succeedingComments != null && this.succeedingComments.size() > 0) {
            newSucceedingComments = new ArrayList<BlockComment>();
            for (BlockComment bc : this.succeedingComments) {
                newSucceedingComments.add((BlockComment)bc.clone());
            }
        }
        return new CommentableObject(newPrecedingComments, newSucceedingComments);
    }

    public List<BlockComment> getPrecedingComments() {
        return this.precedingComments;
    }

    public List<BlockComment> getSucceedingComments() {
        return this.succeedingComments;
    }
}

