/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.parser.gringo;

import aspmodificator.model.LineBase;
import aspmodificator.parser.gringo.Literal;
import java.util.ArrayList;
import java.util.List;

public class ComputeCommand
extends LineBase {
    protected Integer number = null;
    protected List<Literal> computeLiteralList;

    public ComputeCommand(List<Literal> computeLiteralList, int startLineNo) {
        this(computeLiteralList, null, startLineNo);
    }

    public ComputeCommand(List<Literal> computeLiteralList, Integer num, int startLineNo) {
        super(startLineNo);
        this.computeLiteralList = computeLiteralList;
        this.number = num;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ArrayList<Literal> newList = null;
        if (this.computeLiteralList != null && this.computeLiteralList.size() > 0) {
            newList = new ArrayList<Literal>();
            for (Literal lit : this.computeLiteralList) {
                newList.add((Literal)lit.clone());
            }
        }
        return new ComputeCommand(newList, this.number, this.startLineNo);
    }

    public List<Literal> getComputeLiteralList() {
        return this.computeLiteralList;
    }

    public Integer getNumber() {
        return this.number;
    }

    public void setComputeLiteralList(List<Literal> computeLiteralList) {
        this.computeLiteralList = computeLiteralList;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    @Override
    public String toOutputString() {
        int currentLineNo = this.startLineNo;
        StringBuffer sb = new StringBuffer();
        sb.append("#compute");
        if (this.number != null) {
            sb.append(" ");
            sb.append(this.number.toString());
        }
        sb.append(" { ");
        if (this.computeLiteralList != null && this.computeLiteralList.size() > 0) {
            Literal lit = null;
            int i = 0;
            while (i < this.computeLiteralList.size() - 1) {
                lit = this.computeLiteralList.get(i);
                while (lit.getLineNo() > currentLineNo) {
                    sb.append("\n");
                    ++currentLineNo;
                }
                sb.append(lit.toString());
                sb.append(", ");
                ++i;
            }
            lit = this.computeLiteralList.get(this.computeLiteralList.size() - 1);
            while (lit.getLineNo() > currentLineNo) {
                sb.append("\n");
                ++currentLineNo;
            }
            sb.append(lit.toString());
        }
        sb.append(" }.");
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("#compute");
        if (this.number != null) {
            sb.append(" ");
            sb.append(this.number.toString());
        }
        sb.append(" { ");
        if (this.computeLiteralList != null && this.computeLiteralList.size() > 0) {
            Literal lit = null;
            int i = 0;
            while (i < this.computeLiteralList.size() - 1) {
                lit = this.computeLiteralList.get(i);
                sb.append(lit.toString());
                sb.append(", ");
                ++i;
            }
            lit = this.computeLiteralList.get(this.computeLiteralList.size() - 1);
            sb.append(lit.toString());
        }
        sb.append(" }.");
        return sb.toString();
    }
}

