/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.parser.gringo;

import aspmodificator.parser.gringo.BlockComment;
import aspmodificator.parser.gringo.Literal;
import aspmodificator.parser.gringo.Term;
import java.util.List;

public class CondLit
extends Literal {
    private Literal literal;
    private Term weight;
    private boolean defaultWeight = true;

    protected CondLit() {
    }

    public CondLit(Literal lit, Term weight, List<Literal> cond, int lineNo, boolean isDefaultWeight) {
        super(null, cond, lineNo);
        this.literal = lit;
        this.weight = weight;
        this.defaultWeight = isDefaultWeight;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CondLit condLit = (CondLit)super.clone();
        Literal newLit = null;
        if (this.literal != null) {
            newLit = (Literal)this.literal.clone();
        }
        Term newWeight = null;
        if (this.weight != null) {
            newWeight = (Term)this.weight.clone();
        }
        condLit.setLiteral(newLit);
        condLit.setWeight(newWeight);
        return condLit;
    }

    public Term getWeight() {
        return this.weight;
    }

    public boolean hasDefaultWeight() {
        return this.defaultWeight;
    }

    private void setLiteral(Literal lit) {
        this.literal = lit;
    }

    public void setWeight(Term weight) {
        this.weight = weight;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.precedingComments != null && this.precedingComments.size() > 0) {
            for (BlockComment bc : this.precedingComments) {
                sb.append(bc.getText());
            }
        }
        if (this.literal != null) {
            sb.append(this.literal.toString());
        }
        if (this.terms != null && this.terms.size() > 0) {
            sb.append(" : ");
            int i = 0;
            while (i < this.terms.size() - 1) {
                sb.append(((Literal)this.terms.get(i)).toString());
                sb.append(", ");
                ++i;
            }
            sb.append(((Literal)this.terms.get(this.terms.size() - 1)).toString());
        }
        if (!(this.weight == null || this.weight.toString().equals("1") && this.hasDefaultWeight())) {
            sb.append(" = ");
            sb.append(this.weight.toString());
        }
        if (this.succeedingComments != null && this.succeedingComments.size() > 0) {
            for (BlockComment bc : this.succeedingComments) {
                sb.append(bc.getText());
            }
        }
        return sb.toString();
    }
}

