/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.parser.gringo;

import aspmodificator.model.LineBase;
import aspmodificator.parser.gringo.Signed;
import aspmodificator.parser.gringo.VarTerm;
import java.util.ArrayList;
import java.util.List;

public class DomainDefinition
extends LineBase {
    private Signed identifier;
    private List<VarTerm> vars;

    public DomainDefinition(Signed id, List<VarTerm> vars) {
        this.identifier = id;
        this.vars = vars;
    }

    public DomainDefinition(Signed id, List<VarTerm> vars, int lineNo) {
        super(lineNo);
        this.identifier = id;
        this.vars = vars;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ArrayList<VarTerm> newVars = null;
        if (this.vars != null) {
            newVars = new ArrayList<VarTerm>();
            for (VarTerm t : this.vars) {
                newVars.add((VarTerm)t.clone());
            }
        }
        return new DomainDefinition((Signed)this.identifier.clone(), newVars, this.startLineNo);
    }

    @Override
    public String toOutputString() {
        return this.toString();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("#domain");
        if (this.identifier != null) {
            sb.append(this.identifier.toString());
        }
        if (this.vars != null && this.vars.size() > 0) {
            sb.append("(");
            int i = 0;
            while (i < this.vars.size() - 1) {
                sb.append(this.vars.get(i).toString());
                sb.append(", ");
                ++i;
            }
            sb.append(this.vars.get(this.vars.size() - 1).toString());
            sb.append(")");
        }
        return sb.toString();
    }
}

