/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.parser.gringo;

import aspmodificator.model.LineBase;
import aspmodificator.parser.gringo.Literal;
import aspmodificator.parser.gringo.Predicate;
import aspmodificator.parser.gringo.Signed;
import java.util.ArrayList;
import java.util.List;

public class ExternalStatement
extends LineBase {
    private Predicate pred;
    private List<Literal> list;
    private Integer num;

    public ExternalStatement(Predicate pred, List<Literal> list, int startLineNo) {
        super(startLineNo);
        this.pred = pred;
        this.list = list;
    }

    public ExternalStatement(Signed id, Integer num, int startLineNo) {
        super(startLineNo);
        this.pred = id;
        this.num = num;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (this.list != null) {
            ArrayList<Literal> newList = new ArrayList<Literal>();
            for (Literal lit : this.list) {
                newList.add((Literal)lit.clone());
            }
            return new ExternalStatement((Predicate)this.pred.clone(), newList, this.startLineNo);
        }
        if (this.num != null) {
            return new ExternalStatement((Signed)this.pred.clone(), new Integer(this.num), this.startLineNo);
        }
        return new ExternalStatement((Predicate)this.pred.clone(), null, this.startLineNo);
    }

    @Override
    public String toOutputString() {
        StringBuffer sb = new StringBuffer();
        sb.append("#external ");
        sb.append(this.pred.toString());
        if (this.list != null) {
            Literal lit;
            sb.append(" ");
            int currentLineNo = 0;
            currentLineNo = this.list.get(0).getLineNo();
            int i = 0;
            while (i < this.list.size() - 1) {
                lit = this.list.get(i);
                while (lit.getLineNo() > currentLineNo) {
                    sb.append("\n");
                    ++currentLineNo;
                }
                sb.append(lit.toString());
                sb.append(" : ");
                ++i;
            }
            lit = this.list.get(this.list.size() - 1);
            while (lit.getLineNo() > currentLineNo) {
                sb.append("\n");
                ++currentLineNo;
            }
            sb.append(lit.toString());
        } else if (this.num != null) {
            sb.append("/ ");
            sb.append(this.num.toString());
        }
        sb.append(".");
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("#external ");
        sb.append(this.pred.toString());
        if (this.list != null) {
            Literal lit;
            sb.append(" ");
            int i = 0;
            while (i < this.list.size() - 1) {
                lit = this.list.get(i);
                sb.append(lit.toString());
                sb.append(" : ");
                ++i;
            }
            lit = this.list.get(this.list.size() - 1);
            sb.append(lit.toString());
        } else if (this.num != null) {
            sb.append("/ ");
            sb.append(this.num.toString());
        }
        sb.append(".");
        return sb.toString();
    }
}

