/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.parser.gringo;

import aspmodificator.model.LineBase;
import aspmodificator.parser.gringo.BlockComment;
import aspmodificator.parser.gringo.CommentableObject;
import aspmodificator.parser.gringo.ICommentable;
import aspmodificator.parser.gringo.Literal;
import java.util.ArrayList;
import java.util.List;

public class GringoRule
extends LineBase {
    private List<Literal> head;
    private List<Literal> body;
    private CommentableObject centerCommentable;
    private CommentableObject backCommentable;

    public GringoRule(List<Literal> h, List<Literal> b) {
        this.head = h;
        this.body = b;
        this.centerCommentable = new CommentableObject();
        this.backCommentable = new CommentableObject();
    }

    public GringoRule(List<Literal> h, List<Literal> b, int lineNo) {
        super(lineNo);
        this.head = h;
        this.body = b;
        this.centerCommentable = new CommentableObject();
        this.backCommentable = new CommentableObject();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ArrayList<Literal> newHead = null;
        if (this.head != null) {
            newHead = new ArrayList<Literal>();
            for (Literal lit : this.head) {
                newHead.add((Literal)lit.clone());
            }
        }
        ArrayList<Literal> newBody = null;
        if (this.body != null) {
            newBody = new ArrayList<Literal>();
            for (Literal lit : this.body) {
                newBody.add((Literal)lit.clone());
            }
        }
        CommentableObject newCenterCommentable = null;
        CommentableObject newBackCommentable = null;
        if (this.centerCommentable != null) {
            newCenterCommentable = (CommentableObject)this.centerCommentable.clone();
        }
        if (this.backCommentable != null) {
            newBackCommentable = (CommentableObject)this.backCommentable.clone();
        }
        GringoRule tmpRule = new GringoRule(newHead, newBody, this.startLineNo);
        tmpRule.setCenterCommentable(newCenterCommentable);
        tmpRule.setBackCommentable(newBackCommentable);
        return tmpRule;
    }

    public ICommentable getBackCommentable() {
        return this.backCommentable;
    }

    public List<Literal> getBody() {
        return this.body;
    }

    public ICommentable getCenterCommentable() {
        return this.centerCommentable;
    }

    public List<Literal> getHead() {
        return this.head;
    }

    private void setBackCommentable(CommentableObject backCommentable) {
        this.backCommentable = backCommentable;
    }

    public void setBody(List<Literal> body) {
        this.body = body;
    }

    private void setCenterCommentable(CommentableObject centerCommentable) {
        this.centerCommentable = centerCommentable;
    }

    public void setHead(List<Literal> head) {
        this.head = head;
    }

    @Override
    public String toOutputString() {
        int i;
        int currentLineNo = 0;
        Literal lit = null;
        StringBuffer sb = new StringBuffer();
        if (this.head != null && this.head.size() > 0) {
            currentLineNo = this.head.get(0).getLineNo();
            i = 0;
            while (i < this.head.size() - 1) {
                lit = this.head.get(i);
                while (lit.getLineNo() > currentLineNo) {
                    sb.append("\n");
                    ++currentLineNo;
                }
                sb.append(lit.toString());
                sb.append(" | ");
                ++i;
            }
            lit = this.head.get(this.head.size() - 1);
            while (lit.getLineNo() > currentLineNo) {
                sb.append("\n");
                ++currentLineNo;
            }
            sb.append(lit.toString());
            if (this.body != null) {
                sb.append(" ");
            }
        }
        if (this.body != null && this.body.size() > 0) {
            if (currentLineNo == 0) {
                currentLineNo = this.body.get(0).getLineNo();
            }
            if (this.centerCommentable != null && this.centerCommentable.getPrecedingComments() != null && !this.centerCommentable.getPrecedingComments().isEmpty()) {
                for (BlockComment bc : this.centerCommentable.getPrecedingComments()) {
                    sb.append(bc.toString());
                }
            }
            sb.append(":- ");
            if (this.centerCommentable != null && this.centerCommentable.getSucceedingComments() != null && !this.centerCommentable.getSucceedingComments().isEmpty()) {
                for (BlockComment bc : this.centerCommentable.getSucceedingComments()) {
                    sb.append(bc.toString());
                }
            }
            i = 0;
            while (i < this.body.size() - 1) {
                lit = this.body.get(i);
                while (lit.getLineNo() > currentLineNo) {
                    sb.append("\n");
                    ++currentLineNo;
                }
                sb.append(lit.toString());
                sb.append(", ");
                ++i;
            }
            lit = this.body.get(this.body.size() - 1);
            while (lit.getLineNo() > currentLineNo) {
                sb.append("\n");
                ++currentLineNo;
            }
            sb.append(lit.toString());
        }
        if (this.backCommentable != null && this.backCommentable.getPrecedingComments() != null && !this.backCommentable.getPrecedingComments().isEmpty()) {
            for (BlockComment bc : this.backCommentable.getPrecedingComments()) {
                sb.append(bc.toString());
            }
        }
        sb.append(".");
        if (this.backCommentable != null && this.backCommentable.getSucceedingComments() != null && !this.backCommentable.getSucceedingComments().isEmpty()) {
            for (BlockComment bc : this.backCommentable.getSucceedingComments()) {
                sb.append(bc.toString());
            }
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        if (this.head != null && this.head.size() > 0) {
            i = 0;
            while (i < this.head.size() - 1) {
                sb.append(this.head.get(i).toString());
                sb.append(" | ");
                ++i;
            }
            sb.append(this.head.get(this.head.size() - 1).toString());
            if (this.body != null) {
                sb.append(" ");
            }
        }
        if (this.body != null && this.body.size() > 0) {
            sb.append(":- ");
            i = 0;
            while (i < this.body.size() - 1) {
                sb.append(this.body.get(i).toString());
                sb.append(", ");
                ++i;
            }
            sb.append(this.body.get(this.body.size() - 1).toString());
        }
        sb.append(".");
        return sb.toString();
    }
}

