/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.parser.gringo;

import aspmodificator.parser.gringo.BlockComment;
import aspmodificator.parser.gringo.ICommentable;
import aspmodificator.parser.gringo.VarTerm;
import common.Pair;
import java.util.ArrayList;
import java.util.List;

public class Literal
implements ICommentable {
    protected boolean signed;
    protected List<Literal> terms;
    protected String identifier;
    protected List<BlockComment> precedingComments;
    protected List<BlockComment> succeedingComments;
    protected boolean modified = false;
    protected int lineNo = -1;

    public static List<Literal> findClassesByType(Class<?> clazz, Literal lit) {
        ArrayList<Literal> result = new ArrayList<Literal>();
        if (lit.getClass().equals(clazz)) {
            result.add(lit);
        }
        if (lit.getTerms() != null && lit.getTerms().size() > 0) {
            for (Literal term : lit.getTerms()) {
                result.addAll(Literal.findClassesByType(clazz, term));
            }
        }
        return result;
    }

    public static List<Pair<Literal, Literal>> findClassesByTypeWithParent(Class<?> clazz, List<Literal> literalList, Literal parent) {
        ArrayList<Pair<Literal, Literal>> result = new ArrayList<Pair<Literal, Literal>>();
        if (literalList == null || literalList.size() == 0) {
            return result;
        }
        for (Literal lit : literalList) {
            if (clazz.equals(lit.getClass())) {
                result.add(new Pair<Literal, Literal>(lit, parent));
            }
            if (lit.getTerms() == null || lit.getTerms().size() <= 0) continue;
            result.addAll(Literal.findClassesByTypeWithParent(clazz, lit.getTerms(), lit));
        }
        return result;
    }

    public Literal() {
    }

    public Literal(Literal lit) {
        this.identifier = lit.identifier;
        this.lineNo = lit.lineNo;
        this.modified = lit.modified;
        this.precedingComments = lit.precedingComments;
        this.signed = lit.signed;
        this.succeedingComments = lit.succeedingComments;
        this.terms = lit.terms;
    }

    protected Literal(String identifier, List<Literal> terms) {
        this.identifier = identifier;
        this.terms = terms;
        this.signed = false;
        this.lineNo = -1;
    }

    public Literal(String id, List<Literal> terms, boolean signed) {
        this.identifier = id;
        this.terms = terms;
        this.signed = signed;
    }

    public Literal(String id, List<Literal> terms, boolean signed, int lineNo) {
        this.identifier = id;
        this.terms = terms;
        this.signed = signed;
        this.lineNo = lineNo;
    }

    public Literal(String identifier, List<Literal> terms, boolean signed, List<BlockComment> precedingComments, List<BlockComment> succeedingComments) {
        this.signed = signed;
        this.terms = terms;
        this.identifier = identifier;
        this.precedingComments = precedingComments;
        this.succeedingComments = succeedingComments;
    }

    public Literal(String identifier, List<Literal> terms, boolean signed, List<BlockComment> precedingComments, List<BlockComment> succeedingComments, int lineNo) {
        this.signed = signed;
        this.terms = terms;
        this.identifier = identifier;
        this.precedingComments = precedingComments;
        this.succeedingComments = succeedingComments;
        this.lineNo = lineNo;
    }

    protected Literal(String identifier, List<Literal> terms, int lineNo) {
        this.identifier = identifier;
        this.terms = terms;
        this.signed = false;
        this.lineNo = lineNo;
    }

    @Override
    public void addPrecedingComment(String bc) {
        if (this.precedingComments == null) {
            this.precedingComments = new ArrayList<BlockComment>();
        }
        this.precedingComments.add(0, new BlockComment(bc));
    }

    @Override
    public void addSucceedingComment(String bc) {
        if (this.succeedingComments == null) {
            this.succeedingComments = new ArrayList<BlockComment>();
        }
        this.succeedingComments.add(0, new BlockComment(bc));
    }

    public Object clone() throws CloneNotSupportedException {
        ArrayList<Literal> newTerms = null;
        if (this.terms != null) {
            newTerms = new ArrayList<Literal>();
            for (Literal lit : this.terms) {
                newTerms.add((Literal)lit.clone());
            }
        }
        ArrayList<BlockComment> newPrecedingComments = null;
        if (this.precedingComments != null) {
            newPrecedingComments = new ArrayList<BlockComment>();
            for (BlockComment c : this.precedingComments) {
                newPrecedingComments.add((BlockComment)c.clone());
            }
        }
        ArrayList<BlockComment> newSucceedingComments = null;
        if (this.succeedingComments != null) {
            newSucceedingComments = new ArrayList<BlockComment>();
            for (BlockComment c : this.succeedingComments) {
                newSucceedingComments.add((BlockComment)c.clone());
            }
        }
        Literal newLit = null;
        try {
            newLit = (Literal)this.getClass().newInstance();
            if (this.identifier != null) {
                newLit.setIdentifier(new String(this.identifier));
            }
            newLit.setTerms(newTerms);
            newLit.setSigned(this.signed);
            newLit.setPrecedingComments(newPrecedingComments);
            newLit.setSucceedingComments(newSucceedingComments);
            newLit.setLineNo(this.lineNo);
        }
        catch (InstantiationException e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
        return newLit;
    }

    public boolean equalSignature(Literal lit) {
        if (!this.getClass().equals(lit.getClass())) {
            return false;
        }
        return lit.getIdentifier().equals(this.getIdentifier()) && lit.getArity() == this.getArity();
    }

    public int getArity() {
        if (this.terms == null) {
            return 0;
        }
        return this.terms.size();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public List<BlockComment> getPrecedingComments() {
        return this.precedingComments;
    }

    public List<BlockComment> getSucceedingComments() {
        return this.succeedingComments;
    }

    public List<Literal> getTerms() {
        return this.terms;
    }

    public List<VarTerm> getVariables() {
        if (this.terms == null || this.terms.size() == 0) {
            return null;
        }
        List<VarTerm> result = null;
        for (Literal term : this.terms) {
            if (result == null) {
                result = term.getVariables();
                continue;
            }
            List<VarTerm> tmp = term.getVariables();
            if (tmp == null) continue;
            result.addAll(tmp);
        }
        return result;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    private void setLineNo(int lineNo) {
        this.lineNo = lineNo;
    }

    public void setModified(boolean b) {
        this.modified = b;
    }

    public void setPrecedingComments(List<BlockComment> precedingComments) {
        this.precedingComments = precedingComments;
    }

    public void setSigned(boolean signed) {
        this.signed = signed;
    }

    public void setSucceedingComments(List<BlockComment> succeedingComments) {
        this.succeedingComments = succeedingComments;
    }

    public void setTerms(List<Literal> terms) {
        this.terms = terms;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.precedingComments != null && this.precedingComments.size() > 0) {
            for (BlockComment bc : this.precedingComments) {
                sb.append(" ");
                sb.append(bc.getText());
                sb.append(" ");
            }
        }
        if (this.signed) {
            sb.append("not ");
        }
        if (this.identifier != null) {
            sb.append(this.identifier);
        }
        if (this.terms != null && this.terms.size() > 0) {
            sb.append("(");
            int i = 0;
            while (i < this.terms.size() - 1) {
                sb.append(this.terms.get(i).toString());
                sb.append(", ");
                ++i;
            }
            sb.append(this.terms.get(this.terms.size() - 1).toString());
            sb.append(")");
        }
        if (this.succeedingComments != null && this.succeedingComments.size() > 0) {
            for (BlockComment bc : this.succeedingComments) {
                sb.append(" ");
                sb.append(bc.getText());
                sb.append(" ");
            }
        }
        return sb.toString();
    }
}

